/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IEnableChannelDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceDomainComponent;

abstract class BaseEnableChannelHandler
extends BaseControlViewHandler {
    protected CommandParameter fParam;

    BaseEnableChannelHandler() {
    }

    public abstract void enableChannel(CommandParameter var1, List<String> var2, IChannelInfo var3, boolean var4, IProgressMonitor var5) throws ExecutionException;

    public abstract TraceDomainComponent getDomain(CommandParameter var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            final CommandParameter param = this.fParam.clone();
            final IEnableChannelDialog dialog = TraceControlDialogFactory.getInstance().getEnableChannelDialog();
            dialog.setDomainComponent(this.getDomain(param));
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_CreateChannelStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    ArrayList<String> channelNames = new ArrayList<String>();
                    channelNames.add(dialog.getChannelInfo().getName());
                    try {
                        BaseEnableChannelHandler.this.enableChannel(param, channelNames, dialog.getChannelInfo(), dialog.isKernel(), monitor);
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    BaseEnableChannelHandler.this.refresh(param);
                    if (error != null) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_CreateChannelStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }
}

