/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class IntegerDefinition
extends Definition {
    private final IntegerDeclaration declaration;
    private long value;

    public IntegerDefinition(IntegerDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long val) {
        this.value = val;
    }

    public IntegerDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void read(BitBuffer input) {
        int align = (int)this.declaration.getAlignment();
        int pos = input.position() + (align - input.position() % align) % align;
        input.position(pos);
        boolean signed = this.declaration.isSigned();
        int length = this.declaration.getLength();
        long bits = 0L;
        if (length == 64) {
            long low = input.getInt(32, false);
            long high = input.getInt(32, false);
            bits = (high &= 0xFFFFFFFFL) << 32 | (low &= 0xFFFFFFFFL);
        } else {
            bits = input.getInt(length, signed);
            bits &= 0xFFFFFFFFL;
        }
        this.value = bits;
    }

    @Override
    public String toString() {
        if (this.declaration.isCharacter()) {
            char c = (char)this.value;
            return Character.toString(c);
        }
        return String.valueOf(this.value);
    }
}

