/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;

public abstract class ParsingWizardPage
extends WizardPage {
    protected ModifyListener textListener = new TextModifyListener();
    protected ModifyListener regExListener = new RegExModifyListener();
    protected DataSetWizard wizard;
    public static final int COLUMNS = 3;
    private static final int MAX_SERIES = 24;
    protected Text txtSeries;
    protected Text[] txtRegExpr;
    protected Label lblRegEx;
    private Composite cmpTextFields;
    protected String[] labels;
    protected String[] regEx;

    public ParsingWizardPage(String title) {
        super(title);
    }

    public void createControl(Composite parent) {
        this.wizard = (DataSetWizard)super.getWizard();
    }

    protected void createColumnSelector(Composite parent) {
        Label lblSeries = new Label(parent, 0);
        lblSeries.setText(Localization.getString("ParsingWizardPage.NumberOfColumns"));
        lblSeries.setBounds(0, 5, 130, 25);
        this.txtSeries = new Text(parent, 2048);
        this.txtSeries.setBounds(135, 0, 100, 25);
        this.txtSeries.setText("2");
        this.txtSeries.setTextLimit(2);
        this.txtSeries.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!"".equals(ParsingWizardPage.this.txtSeries.getText().trim())) {
                    ParsingWizardPage.this.displayTextBoxes();
                    ParsingWizardPage.this.refreshRegEx();
                }
            }
        });
        this.txtSeries.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (('0' > e.character || '9' < e.character) && '\u001f' < e.character && '\u007f' > e.character) {
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label lblRegExTitle = new Label(parent, 0);
        lblRegExTitle.setText(Localization.getString("ParsingWizardPage.RegularExpression"));
        lblRegExTitle.setBounds(5, 325, 150, 20);
        this.lblRegEx = new Label(parent, 0);
        this.lblRegEx.setBounds(155, 325, 300, 20);
        Label lblTitle = new Label(parent, 0);
        lblTitle.setText(Localization.getString("ParsingWizardPage.Title"));
        lblTitle.setBounds(0, 45, 150, 25);
        Label lblExpr = new Label(parent, 0);
        lblExpr.setText(Localization.getString("ParsingWizardPage.RegularExpression"));
        lblExpr.setBounds(160, 45, 150, 25);
        Label lblSpace = new Label(parent, 0);
        lblSpace.setText(Localization.getString("ParsingWizardPage.Delimiter"));
        lblSpace.setBounds(310, 45, 150, 25);
        ScrolledComposite sc1 = new ScrolledComposite(parent, 2816);
        sc1.setBounds(0, 70, 475, 250);
        this.cmpTextFields = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)this.cmpTextFields);
        this.txtRegExpr = new Text[72];
        int i = 0;
        while (i < this.txtRegExpr.length) {
            this.txtRegExpr[i] = new Text(this.cmpTextFields, 2048);
            this.txtRegExpr[i].setBounds(150 * (i % 3), 30 * (i / 3), 140, 25);
            if (2 == i % 3) {
                this.txtRegExpr[i].setText("\\D+");
            } else if (1 == i % 3) {
                this.txtRegExpr[i].setText("\\d+");
            }
            ++i;
        }
        this.readParsingExpression();
        i = 0;
        while (i < this.txtRegExpr.length) {
            if (i % 3 != 0) {
                this.txtRegExpr[i].addModifyListener(this.regExListener);
            } else {
                this.txtRegExpr[i].addModifyListener(this.textListener);
            }
            ++i;
        }
        this.displayTextBoxes();
        this.refreshRegEx();
    }

    private void displayTextBoxes() {
        int series = Integer.parseInt(this.txtSeries.getText());
        if (series > 24) {
            this.txtSeries.setText("24");
            return;
        }
        this.cmpTextFields.setSize(450, series * 30);
        series *= 3;
        int i = 0;
        while (i < this.txtRegExpr.length) {
            if (i < series) {
                this.txtRegExpr[i].setVisible(true);
            } else {
                this.txtRegExpr[i].setVisible(false);
            }
            ++i;
        }
    }

    private void refreshRegEx() {
        int series = Integer.parseInt(this.txtSeries.getText());
        series *= 3;
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < series) {
            if (i % 3 != 0) {
                s.append(this.txtRegExpr[i].getText());
            }
            ++i;
        }
        this.lblRegEx.setText(s.toString());
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void dispose() {
        if (this.txtRegExpr != null) {
            int i = 0;
            while (i < this.txtRegExpr.length) {
                if (this.txtRegExpr[i] != null) {
                    if (i % 3 != 0) {
                        this.txtRegExpr[i].removeModifyListener(this.regExListener);
                    } else {
                        this.txtRegExpr[i].removeModifyListener(this.textListener);
                    }
                    this.txtRegExpr[i].dispose();
                }
                this.txtRegExpr[i] = null;
                ++i;
            }
            this.txtRegExpr = null;
        }
        super.dispose();
    }

    public boolean checkComplete() {
        int series = Integer.parseInt(this.txtSeries.getText());
        this.labels = new String[series];
        this.regEx = new String[series * 2];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < series * 3) {
            if ("".equals(this.txtRegExpr[i].getText())) {
                this.regEx = null;
                this.wizard.parser = null;
                this.wizard.dataSet = null;
                return false;
            }
            if (i % 3 == 0) {
                this.labels[j] = this.txtRegExpr[i].getText();
                ++j;
            } else {
                this.regEx[k] = this.txtRegExpr[i].getText();
                ++k;
            }
            ++i;
        }
        return true;
    }

    abstract boolean readParsingExpression();

    abstract void copyExisting(IMemento var1, IMemento var2);

    private class RegExModifyListener
    extends TextModifyListener {
        private RegExModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            ParsingWizardPage.this.refreshRegEx();
        }
    }

    protected class TextModifyListener
    implements ModifyListener {
        protected TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ParsingWizardPage.this.checkComplete();
            ParsingWizardPage.this.wizard.getContainer().updateButtons();
        }
    }
}

