/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TimeGraphTooltipHandler {
    private Shell _tipShell;
    private Table _tipTable;
    private Point _tipPosition;
    private ITimeDataProvider _timeDataProvider;
    ITimeGraphPresentationProvider _utilImp = null;

    public TimeGraphTooltipHandler(Shell parent, ITimeGraphPresentationProvider rUtilImpl, ITimeDataProvider timeProv) {
        Display display = parent.getDisplay();
        this._utilImp = rUtilImpl;
        this._timeDataProvider = timeProv;
        this._tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this._tipShell.setLayout((Layout)gridLayout);
        GridData data = new GridData(1, 1, true, true);
        this._tipShell.setLayoutData((Object)data);
        this._tipShell.setBackground(display.getSystemColor(29));
        this._tipTable = new Table((Composite)this._tipShell, 0);
        new TableColumn(this._tipTable, 0);
        new TableColumn(this._tipTable, 0);
        this._tipTable.setForeground(display.getSystemColor(28));
        this._tipTable.setBackground(display.getSystemColor(29));
        this._tipTable.setHeaderVisible(false);
        this._tipTable.setLinesVisible(false);
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell.isVisible()) {
                    TimeGraphTooltipHandler.this._tipShell.setVisible(false);
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell.isVisible()) {
                    TimeGraphTooltipHandler.this._tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell.isVisible()) {
                    TimeGraphTooltipHandler.this._tipShell.setVisible(false);
                }
            }

            private void addItem(String name, String value) {
                TableItem line = new TableItem(TimeGraphTooltipHandler.this._tipTable, 0);
                line.setText(0, name);
                line.setText(1, value);
            }

            private void fillValues(Point pt, TimeGraphControl threadStates, TimeGraphItem item) {
                if (item == null) {
                    return;
                }
                if (!item._trace.hasTimeEvents()) {
                    this.addItem(Messages.TmfTimeTipHandler_TRACE_GROUP_NAME, item.toString());
                    this.addItem(Messages.TmfTimeTipHandler_NUMBER_OF_TRACES, "" + item.children.size());
                } else {
                    Map<String, String> eventAddOns;
                    ITimeGraphEntry thrd = item._trace;
                    ITimeEvent threadEvent = Utils.findEvent(thrd, threadStates.getTimeAtX(pt.x), 2);
                    ITimeEvent nextEvent = Utils.findEvent(thrd, threadStates.getTimeAtX(pt.x), 1);
                    this.addItem(TimeGraphTooltipHandler.this._utilImp.getStateTypeName(), thrd.getName());
                    if (threadEvent == null) {
                        return;
                    }
                    String state = TimeGraphTooltipHandler.this._utilImp.getEventName(threadEvent);
                    if (state != null) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STATE, state);
                    }
                    if ((eventAddOns = TimeGraphTooltipHandler.this._utilImp.getEventHoverToolTipInfo(threadEvent)) != null) {
                        for (String message : eventAddOns.keySet()) {
                            this.addItem(message, eventAddOns.get(message));
                        }
                    }
                    long eventStartTime = -1L;
                    long eventDuration = -1L;
                    long eventEndTime = -1L;
                    if (threadEvent != null) {
                        eventStartTime = threadEvent.getTime();
                        eventDuration = threadEvent.getDuration();
                        if (eventDuration < 0L && nextEvent != null) {
                            eventEndTime = nextEvent.getTime();
                            eventDuration = eventEndTime - eventStartTime;
                        } else {
                            eventEndTime = eventStartTime + eventDuration;
                        }
                    }
                    Utils.Resolution res = Utils.Resolution.NANOSEC;
                    if (TimeGraphTooltipHandler.this._timeDataProvider.isCalendarFormat()) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_DATE, eventStartTime > -1L ? Utils.formatDate(eventStartTime) : "?");
                        if (eventDuration > 0L) {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                        } else {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                        }
                    } else if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.RELATIVE, res) : "?");
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, Utils.TimeFormat.RELATIVE, res) : "?");
                    } else {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.RELATIVE, res) : "?");
                    }
                    if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_DURATION, eventDuration > -1L ? Utils.formatTime(eventDuration, Utils.TimeFormat.RELATIVE, res) : "?");
                    }
                }
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TimeGraphControl threadStates = (TimeGraphControl)event.widget;
                TimeGraphItem item = threadStates.getItem(pt);
                TimeGraphTooltipHandler.this._tipTable.remove(0, TimeGraphTooltipHandler.this._tipTable.getItemCount() - 1);
                this.fillValues(pt, threadStates, item);
                TimeGraphTooltipHandler.this._tipTable.getColumn(0).setWidth(200);
                TimeGraphTooltipHandler.this._tipTable.getColumn(1).pack();
                TimeGraphTooltipHandler.this._tipTable.setSize(TimeGraphTooltipHandler.this._tipTable.computeSize(-1, 200));
                TimeGraphTooltipHandler.this._tipShell.pack();
                TimeGraphTooltipHandler.this._tipPosition = control.toDisplay(pt);
                TimeGraphTooltipHandler.this._tipShell.pack();
                TimeGraphTooltipHandler.this.setHoverLocation(TimeGraphTooltipHandler.this._tipShell, TimeGraphTooltipHandler.this._tipPosition);
                TimeGraphTooltipHandler.this._tipShell.setVisible(true);
            }
        });
    }

    private void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

