/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpointIndexer;

public abstract class TmfTrace<T extends ITmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace<T> {
    private IResource fResource;
    private String fPath;
    private int fCacheSize = 1000;
    private long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private long fStreamingInterval = 0L;
    private ITmfTraceIndexer<ITmfTrace<ITmfEvent>> fIndexer;
    private ITmfEventParser<T> fParser;

    public TmfTrace() {
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize) throws TmfTraceException {
        this(resource, type, path, cacheSize, 0L);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval) throws TmfTraceException {
        this(resource, type, path, cacheSize, interval, null);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval, ITmfTraceIndexer<?> indexer) throws TmfTraceException {
        this(resource, type, path, cacheSize, interval, indexer, null);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval, ITmfTraceIndexer<?> indexer, ITmfEventParser<T> parser) throws TmfTraceException {
        this.fCacheSize = cacheSize > 0 ? cacheSize : 1000;
        this.fStreamingInterval = interval;
        this.fIndexer = indexer != null ? indexer : new TmfCheckpointIndexer(this, this.fCacheSize);
        this.fParser = parser;
        this.initialize(resource, path, type);
    }

    public TmfTrace(TmfTrace<T> trace) throws TmfTraceException {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.fCacheSize = trace.getCacheSize();
        this.fStreamingInterval = trace.getStreamingInterval();
        this.fIndexer = new TmfCheckpointIndexer<ITmfTrace<ITmfEvent>>(this);
        this.fParser = trace.fParser;
        this.initialize(trace.getResource(), trace.getPath(), trace.getEventType());
    }

    @Override
    public void initTrace(IResource resource, String path, Class<T> type) throws TmfTraceException {
        this.fIndexer = new TmfCheckpointIndexer<ITmfTrace<ITmfEvent>>(this, this.fCacheSize);
        this.initialize(resource, path, type);
    }

    protected void initialize(IResource resource, String path, Class<T> type) throws TmfTraceException {
        String traceName;
        if (path == null) {
            throw new TmfTraceException("Invalid trace path");
        }
        this.fPath = path;
        this.fResource = resource;
        String string = traceName = resource != null ? resource.getName() : null;
        if (traceName == null) {
            int sep = path.lastIndexOf(47);
            String string2 = traceName = sep >= 0 ? path.substring(sep + 1) : path;
        }
        if (this.fParser == null) {
            if (this instanceof ITmfEventParser) {
                this.fParser = (ITmfEventParser)((Object)this);
            } else {
                throw new TmfTraceException("Invalid trace parser");
            }
        }
        super.init(traceName, type);
    }

    protected boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    protected void indexTrace(boolean waitForCompletion) {
        this.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, waitForCompletion);
    }

    @Override
    public Class<T> getEventType() {
        return super.getType();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public int getCacheSize() {
        return this.fCacheSize;
    }

    @Override
    public long getStreamingInterval() {
        return this.fStreamingInterval;
    }

    protected ITmfTraceIndexer<ITmfTrace<ITmfEvent>> getIndexer() {
        return this.fIndexer;
    }

    protected ITmfEventParser<T> getParser() {
        return this.fParser;
    }

    @Override
    public synchronized long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime.clone();
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime.clone();
    }

    protected void setCacheSize(int cacheSize) {
        this.fCacheSize = cacheSize;
    }

    protected synchronized void setNbEvents(long nbEvents) {
        this.fNbEvents = nbEvents > 0L ? nbEvents : 0L;
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime().clone();
        this.fEndTime = range.getEndTime().clone();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime.clone();
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime.clone();
    }

    protected void setStreamingInterval(long interval) {
        this.fStreamingInterval = interval > 0L ? interval : 0L;
    }

    protected void setIndexer(ITmfTraceIndexer<ITmfTrace<ITmfEvent>> indexer) {
        this.fIndexer = indexer;
    }

    protected void setParser(ITmfEventParser<T> parser) {
        this.fParser = parser;
    }

    @Override
    public synchronized ITmfContext seekEvent(long rank) {
        if (rank <= 0L) {
            ITmfContext context = this.seekEvent((ITmfLocation<?>)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(rank);
        long pos = context.getRank();
        if (pos < rank) {
            T event = this.getNext(context);
            while (event != null && ++pos < rank) {
                event = this.getNext(context);
            }
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            ITmfContext context = this.seekEvent((ITmfLocation<?>)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(timestamp);
        ITmfContext nextEventContext = context.clone();
        T event = this.getNext(nextEventContext);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            context.setLocation(nextEventContext.getLocation().clone());
            context.increaseRank();
            event = this.getNext(nextEventContext);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-1L);
        }
        return context;
    }

    @Override
    public synchronized T getNext(ITmfContext context) {
        T event = this.fParser.parseEvent(context);
        if (event != null) {
            this.updateAttributes(context, event.getTimestamp());
            context.setLocation(this.getCurrentLocation());
            context.increaseRank();
            this.processEvent((ITmfEvent)event);
        }
        return event;
    }

    protected void processEvent(ITmfEvent event) {
    }

    protected synchronized void updateAttributes(ITmfContext context, ITmfTimestamp timestamp) {
        if (this.fStartTime.equals(TmfTimestamp.BIG_BANG) || this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp.clone();
        }
        if (this.fEndTime.equals(TmfTimestamp.BIG_CRUNCH) || this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp.clone();
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            this.fIndexer.updateIndex(context, timestamp);
        }
    }

    @Override
    protected ITmfContext armRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    public synchronized String toString() {
        return "TmfTrace [fPath=" + this.fPath + ", fCacheSize=" + this.fCacheSize + ", fNbEvents=" + this.fNbEvents + ", fStartTime=" + this.fStartTime + ", fEndTime=" + this.fEndTime + ", fStreamingInterval=" + this.fStreamingInterval + "]";
    }
}

