/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.RPMDetailsPanel;
import org.eclipse.linuxtools.rpm.core.RPMProjectCreator;
import org.eclipse.linuxtools.rpm.ui.SRPMImportOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class SRPMImportPage
extends WizardPage {
    private Text sourceSRPM;
    private RPMDetailsPanel detailsPanel;

    public SRPMImportPage(IWorkbench aWorkbench) {
        super(Messages.getString("SRPMImportPage.Import_SRPM"), Messages.getString("SRPMImportPage.Select_project_to_import"), null);
        this.setPageComplete(false);
        this.setDescription(Messages.getString("SRPMImportPage.Select_project_to_import"));
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        this.createSourceRPMCombo(composite);
        this.detailsPanel = new RPMDetailsPanel(composite);
    }

    private void createSourceRPMCombo(Composite parent) {
        Group specGrid = new Group(parent, 0);
        specGrid.setLayout((Layout)new GridLayout());
        specGrid.setText(Messages.getString("SRPMImportPage.SRPM_Name"));
        specGrid.setLayoutData((Object)new GridData(768));
        Composite sourceSpecComposite = new Composite((Composite)specGrid, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        sourceSpecComposite.setLayout((Layout)layout);
        sourceSpecComposite.setLayoutData((Object)new GridData(768));
        this.sourceSRPM = new Text(sourceSpecComposite, 2048);
        this.sourceSRPM.setToolTipText(Messages.getString("SRPMImportPage.toolTip_SRPM_Name"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sourceSRPM.setLayoutData((Object)gridData);
        this.sourceSRPM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean validSRPM = SRPMImportPage.this.canFinish();
                if (validSRPM) {
                    SRPMImportPage.this.setPageComplete(validSRPM);
                    SRPMImportPage.this.changeProjectSettings();
                }
            }
        });
        Button srpmBrowse = new Button(sourceSpecComposite, 8);
        srpmBrowse.setToolTipText(Messages.getString("SRPMImportPage.toolTip_Open_file_navigator"));
        srpmBrowse.setText(Messages.getString("RPMPage.Browse"));
        srpmBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                File testSRPMfilename;
                FileDialog srpmBrowseDialog = new FileDialog(SRPMImportPage.this.getContainer().getShell(), 4096);
                String selectedSRPM_name = srpmBrowseDialog.open();
                if (selectedSRPM_name != null && (testSRPMfilename = new File(selectedSRPM_name)).isFile()) {
                    SRPMImportPage.this.sourceSRPM.setText(selectedSRPM_name);
                }
            }
        });
    }

    private void changeProjectSettings() {
        String srpmName = this.sourceSRPM.getText();
        this.detailsPanel.setLocationPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.getProjectName(srpmName)).toFile().getAbsolutePath());
    }

    private String getProjectName(String srpmName) {
        String projectName = srpmName.substring(srpmName.lastIndexOf(47) + 1);
        return projectName.replaceAll("-[\\d|\\.]+-[\\d|\\.].+", "");
    }

    public boolean canFinish() {
        block8: {
            String sourceSRPMName = this.sourceSRPM.getText();
            if (!sourceSRPMName.isEmpty() && this.sourceSRPM.getText().lastIndexOf(".src.rpm") == -1) {
                this.setErrorMessage(Messages.getString("SRPMImportPage.No_src_rpm_ext"));
                return false;
            }
            if (sourceSRPMName.startsWith("http://")) {
                try {
                    URL url = new URL(sourceSRPMName);
                    if (404 == ((HttpURLConnection)url.openConnection()).getResponseCode()) {
                        this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                        return false;
                    }
                    break block8;
                }
                catch (MalformedURLException malformedURLException) {
                    this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                    return false;
                }
                catch (IOException iOException) {
                    this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                    return false;
                }
            }
            if (sourceSRPMName.equals("")) {
                return false;
            }
            File srpm = new File(sourceSRPMName);
            if (!srpm.isFile()) {
                this.setErrorMessage(Messages.getString("SRPMImportPage.Source_not_Valid"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        IProject detailedProject = this.getNewProject();
        SRPMImportOperation srpmImportOp = null;
        try {
            String srpmName = this.sourceSRPM.getText();
            if (srpmName.startsWith("http://")) {
                URL sourceRPMURL = new URL(srpmName);
                srpmImportOp = new SRPMImportOperation(detailedProject, sourceRPMURL, this.detailsPanel.getSelectedLayout());
            } else {
                File sourceRPMFile = new File(srpmName);
                srpmImportOp = new SRPMImportOperation(detailedProject, sourceRPMFile, this.detailsPanel.getSelectedLayout());
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)srpmImportOp);
        }
        catch (Exception e) {
            this.setErrorMessage(e.toString());
            return false;
        }
        MultiStatus srpmImportStatus = srpmImportOp.getStatus();
        if (!srpmImportStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.getString("SRPMImportPage.Errors_importing_SRPM"), null, (IStatus)srpmImportStatus);
            return false;
        }
        return true;
    }

    private IProject getNewProject() {
        IPath path = this.detailsPanel.getLocationPath();
        RPMProjectCreator projectCreator = new RPMProjectCreator(this.detailsPanel.getSelectedLayout());
        projectCreator.create(this.getProjectName(path.lastSegment()), path.removeLastSegments(1), (IProgressMonitor)new NullProgressMonitor());
        return projectCreator.getLatestProject();
    }
}

