/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfileChangelogScanner;

public class VersionReleaseRule
implements IPredicateRule {
    private StringBuilder fBuffer = new StringBuilder();
    private StringBuilder fWhiteSpaceBuffer = new StringBuilder();
    IToken fToken;
    IToken fPreceedingToken;
    SpecfileChangelogScanner fChangelogScanner;
    protected static final char CHARS_SEPERATOR = '-';
    protected static final int STATE_START = 0;
    protected static final int STATE_VERSION = 1;
    protected static final int STATE_RELEASE = 2;
    protected static final int STATE_TRAIL = 3;
    protected static final int STATE_DONE = 4;

    public VersionReleaseRule(IToken token) {
        this.fToken = token;
    }

    public VersionReleaseRule(IToken successToken, IToken preceedingToken, SpecfileChangelogScanner scanner) {
        this.fToken = successToken;
        this.fPreceedingToken = preceedingToken;
        this.fChangelogScanner = scanner;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        IToken lastToken = this.getLastToken();
        if (lastToken != this.fPreceedingToken) {
            return Token.UNDEFINED;
        }
        this.fBuffer.setLength(0);
        int state = 0;
        int numPreceedingBlanks = 0;
        do {
            int c = scanner.read();
            this.fBuffer.append((char)c);
            if (state == 0) {
                if (Character.isWhitespace((char)c) || c == 45) {
                    ++numPreceedingBlanks;
                } else {
                    ++state;
                }
            }
            if (state == 1) {
                if (this.fBuffer.length() > numPreceedingBlanks && c == 45) {
                    ++state;
                    continue;
                }
                if (Character.isLetterOrDigit((char)c) || c == 46 || c == 95 || c == 58) continue;
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            if (state == 2) {
                if (c == -1 || c == 10) {
                    state = 4;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    ++state;
                    this.fWhiteSpaceBuffer.setLength(0);
                    this.fWhiteSpaceBuffer.append(c);
                    continue;
                }
                if (Character.isLetterOrDigit((char)c) || c == 46 || c == 95) continue;
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            if (state != 3) continue;
            if (c == -1 || c == 10) {
                this.unreadBuffer(scanner, this.fWhiteSpaceBuffer);
                ++state;
                continue;
            }
            if (!Character.isWhitespace((char)c)) {
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            this.fWhiteSpaceBuffer.append((char)c);
        } while (state != 4);
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected void unreadBuffer(ICharacterScanner scanner, StringBuilder buffer) {
        int i = buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    protected IToken getLastToken() {
        return this.fChangelogScanner.getLastToken();
    }
}

