/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.AbsEventToHandlerResolver;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor.ResourcesAfterUpdateHandlers;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor.ResourcesBeforeUpdateHandlers;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor.ResourcesFinishUpdateHandler;

public class ResourcesEventToHandlerFactory
extends AbsEventToHandlerResolver {
    private final Map<String, ILttngEventProcessor> eventNametoBeforeProcessor = new HashMap<String, ILttngEventProcessor>();
    private final Map<String, ILttngEventProcessor> eventNametoAfterProcessor = new HashMap<String, ILttngEventProcessor>();
    private ResourcesFinishUpdateHandler finishProcessor = null;
    private static ResourcesEventToHandlerFactory instance = null;
    private ResourcesBeforeUpdateHandlers instantiateBeforeHandler = new ResourcesBeforeUpdateHandlers();
    private ResourcesAfterUpdateHandlers instantiateAfterHandler = new ResourcesAfterUpdateHandlers();

    private ResourcesEventToHandlerFactory() {
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_SCHED_SCHEDULE.getInName(), this.instantiateBeforeHandler.getBeforeSchedChangeHandler());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_TRAP_ENTRY.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_TRAP_EXIT.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_PAGE_FAULT_ENTRY.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_PAGE_FAULT_EXIT.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_PAGE_FAULT_NOSEM_ENTRY.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_PAGE_FAULT_NOSEM_EXIT.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeTrap());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_IRQ_ENTRY.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeIrq());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_IRQ_EXIT.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeIrq());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_SOFT_IRQ_RAISE.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeSoftIrq());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_SOFT_IRQ_ENTRY.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeSoftIrq());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_SOFT_IRQ_EXIT.getInName(), this.instantiateBeforeHandler.getBeforeExecutionModeSoftIrq());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_REQUEST_ISSUE.getInName(), this.instantiateBeforeHandler.getBeforeBdevEvent());
        this.eventNametoBeforeProcessor.put(StateStrings.Events.LTT_EVENT_REQUEST_COMPLETE.getInName(), this.instantiateBeforeHandler.getBeforeBdevEvent());
        this.eventNametoAfterProcessor.put(StateStrings.Events.LTT_EVENT_SCHED_SCHEDULE.getInName(), this.instantiateAfterHandler.getAfterSchedChangeHandler());
        this.finishProcessor = new ResourcesFinishUpdateHandler();
    }

    public static AbsEventToHandlerResolver getInstance() {
        if (instance == null) {
            instance = new ResourcesEventToHandlerFactory();
        }
        return instance;
    }

    public ILttngEventProcessor getAfterProcessor(String eventType) {
        return this.eventNametoAfterProcessor.get(eventType);
    }

    public ILttngEventProcessor getBeforeProcessor(String eventType) {
        return this.eventNametoBeforeProcessor.get(eventType);
    }

    public ILttngEventProcessor getfinishProcessor() {
        return this.finishProcessor;
    }

    public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
        if (trcEvent instanceof LttngSyntheticEvent) {
            LttngSyntheticEvent synEvent = (LttngSyntheticEvent)trcEvent;
            String eventType = synEvent.getMarkerName();
            ILttngEventProcessor processor = null;
            if (synEvent.getSynType() == LttngSyntheticEvent.SequenceInd.BEFORE) {
                processor = this.getBeforeProcessor(eventType);
            }
            if (synEvent.getSynType() == LttngSyntheticEvent.SequenceInd.AFTER) {
                processor = this.getAfterProcessor(eventType);
            }
            if (synEvent.getSynType() == LttngSyntheticEvent.SequenceInd.ENDREQ) {
                processor = this.getfinishProcessor();
            }
            if (processor != null) {
                processor.process(trcEvent, traceSt);
            }
        }
        return false;
    }

    public ILttngEventProcessor getStateUpdaterProcessor(String eventType) {
        return null;
    }
}

