/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.colors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSetting;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSettingsXML;
import org.eclipse.linuxtools.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.swt.widgets.Display;

public class ColorSettingsManager {
    private static final String COLOR_SETTINGS_FILE_NAME = "color_settings.xml";
    private static final String COLOR_SETTINGS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append("color_settings.xml").toString();
    private static final ColorSetting DEFAULT_COLOR_SETTING = new ColorSetting(Display.getDefault().getSystemColor(24).getRGB(), Display.getDefault().getSystemColor(25).getRGB(), Display.getDefault().getSystemColor(24).getRGB(), null);
    public static final int PRIORITY_NONE = Integer.MAX_VALUE;
    private static ColorSetting[] fColorSettings = ColorSettingsXML.load(COLOR_SETTINGS_PATH_NAME);
    private static List<IColorSettingsListener> fListeners = new ArrayList<IColorSettingsListener>();

    public static ColorSetting[] getColorSettings() {
        return fColorSettings != null ? Arrays.copyOf(fColorSettings, fColorSettings.length) : null;
    }

    public static void setColorSettings(ColorSetting[] colorSettings) {
        fColorSettings = colorSettings != null ? Arrays.copyOf(colorSettings, colorSettings.length) : null;
        ColorSettingsXML.save(COLOR_SETTINGS_PATH_NAME, fColorSettings);
        ColorSettingsManager.fireColorSettingsChanged();
    }

    public static ColorSetting getColorSetting(ITmfEvent event) {
        int i = 0;
        while (i < fColorSettings.length) {
            ColorSetting colorSetting = fColorSettings[i];
            if (colorSetting.getFilter() != null && colorSetting.getFilter().matches(event)) {
                return colorSetting;
            }
            ++i;
        }
        return DEFAULT_COLOR_SETTING;
    }

    public static int getColorSettingPriority(ITmfEvent event) {
        int i = 0;
        while (i < fColorSettings.length) {
            ColorSetting colorSetting = fColorSettings[i];
            if (colorSetting.getFilter() != null && colorSetting.getFilter().matches(event)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public static ColorSetting getColorSetting(int priority) {
        if (priority < fColorSettings.length) {
            return fColorSettings[priority];
        }
        return DEFAULT_COLOR_SETTING;
    }

    public static void addColorSettingsListener(IColorSettingsListener listener) {
        if (!fListeners.contains(listener)) {
            fListeners.add(listener);
        }
    }

    public static void removeColorSettingsListener(IColorSettingsListener listener) {
        fListeners.remove(listener);
    }

    private static void fireColorSettingsChanged() {
        for (IColorSettingsListener listener : fListeners) {
            listener.colorSettingsChanged(fColorSettings);
        }
    }
}

