/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;

public class URLHyperlinkWithMacroDetector
extends URLHyperlinkDetector {
    private Specfile specfile;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink hyperlink;
        IHyperlink[] returned;
        if (this.specfile == null) {
            SpecfileEditor a = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
            if (a != null) {
                this.specfile = a.getSpecfile();
            } else {
                return null;
            }
        }
        if ((returned = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks)) != null && returned.length > 0 && (hyperlink = returned[0]) instanceof URLHyperlink) {
            URLHyperlink urlHyperlink = (URLHyperlink)hyperlink;
            String newURLString = UiUtils.resolveDefines(this.specfile, urlHyperlink.getURLString());
            return new IHyperlink[]{new URLHyperlink(urlHyperlink.getHyperlinkRegion(), newURLString)};
        }
        return returned;
    }

    public void setSpecfile(Specfile specfile) {
        this.specfile = specfile;
    }
}

