/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency;

import org.eclipse.linuxtools.internal.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.GraphMouseListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.GraphPaintListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.TimePointerListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.IGraphDataModel;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.IGraphModelListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.model.LatencyGraphModel;
import org.eclipse.swt.widgets.Composite;

public class GraphViewer
extends AbstractViewer
implements IGraphModelListener {
    private LatencyGraphModel fModel;

    public GraphViewer(Composite parent, int style) {
        super(parent, style);
        this.fPaintListener = new GraphPaintListener(this);
        this.addPaintListener(this.fPaintListener);
        this.fMouseTraceListener = new TimePointerListener(this, (GraphPaintListener)this.fPaintListener);
        this.addMouseTrackListener(this.fMouseTraceListener);
        this.fMouseListener = new GraphMouseListener(this, (GraphPaintListener)this.fPaintListener);
        this.addMouseListener(this.fMouseListener);
        this.fModel = new LatencyGraphModel();
        this.fModel.addGraphModelListener(this);
    }

    @Override
    public void dispose() {
        this.fModel.removeGraphModelListener(this);
        this.fPaintListener.dispose();
        super.dispose();
    }

    @Override
    public void clear() {
        this.fPaintListener.clear();
    }

    @Override
    public void clearBackground() {
        this.fPaintListener.clear();
    }

    @Override
    public void increaseBarWidth() {
        this.fPaintListener.increaseBarWitdh();
        this.graphModelUpdated();
    }

    @Override
    public void decreaseBarWidth() {
        this.fPaintListener.decreaseBarWitdh();
        this.graphModelUpdated();
    }

    @Override
    public IGraphDataModel getModel() {
        return this.fModel;
    }

    @Override
    public void graphModelUpdated() {
        if (!this.isDisposed() && this.getDisplay() != null) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GraphViewer.this.isDisposed()) {
                        GraphViewer.this.redraw();
                    }
                }
            });
        }
    }

    @Override
    public void currentEventUpdated(long currentEventTime) {
        this.graphModelUpdated();
    }
}

