/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfContent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class CtfTmfTrace
extends TmfEventProvider<CtfTmfEvent>
implements ITmfTrace<CtfTmfEvent> {
    private CTFTrace fTrace;
    protected long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private IResource fResource;
    protected IStateSystemQuerier ss = null;

    @Override
    public void initTrace(IResource resource, String path, Class<CtfTmfEvent> eventType) throws TmfTraceException {
        this.fResource = resource;
        try {
            this.fTrace = new CTFTrace(path);
            int i = 0;
            while (i < this.fTrace.getNbEventTypes()) {
                EventDeclaration ed = this.fTrace.getEventType((long)i);
                ITmfEventField eventField = CtfTmfTrace.parseDeclaration(ed);
                new CtfTmfEventType(ed.getName(), eventField);
                ++i;
            }
            CtfIterator iterator = new CtfIterator(this, 0L, 0L);
            if (iterator.getLocation().equals(CtfIterator.NULL_LOCATION)) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                this.setStartTime(iterator.getCurrentEvent().getTimestamp());
                if (iterator.hasMoreEvents()) {
                    iterator.goToLastEvent();
                }
                this.setEndTime(iterator.getCurrentEvent().getTimestamp());
            }
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
        TmfSignalManager.register(this);
        this.buildStateSystem();
        if (resource != null) {
            try {
                resource.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new TmfTraceException(e.getMessage(), e);
            }
        }
    }

    private static ITmfEventField parseDeclaration(EventDeclaration ed) {
        EventDefinition eventDef = ed.createDefinition(null);
        return new CtfTmfContent(":root:", CtfTmfEvent.parseFields(eventDef));
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister(this);
    }

    @Override
    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal(signal);
    }

    @Override
    public boolean validate(IProject project, String path) {
        try {
            CTFTrace temp = new CTFTrace(path);
            return temp.majortIsSet();
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
    }

    @Override
    public Class<CtfTmfEvent> getEventType() {
        return this.fType;
    }

    public int getNbEnvVars() {
        return this.fTrace.getEnvironment().size();
    }

    public String[] getEnvNames() {
        String[] s = new String[this.getNbEnvVars()];
        return this.fTrace.getEnvironment().keySet().toArray(s);
    }

    public String getEnvValue(String key) {
        return (String)this.fTrace.getEnvironment().get(key);
    }

    @Override
    public String getPath() {
        return this.fTrace.getPath();
    }

    @Override
    public String getName() {
        String traceName;
        String string = traceName = this.fResource != null ? this.fResource.getName() : null;
        if (traceName == null) {
            String path = this.fTrace.getPath();
            int sep = path.lastIndexOf(47);
            traceName = sep >= 0 ? path.substring(sep + 1) : path;
        }
        return traceName;
    }

    @Override
    public int getCacheSize() {
        return 50000;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<CtfTmfEvent> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation<?> location) {
        CtfLocation currentLocation = (CtfLocation)location;
        if (currentLocation == null) {
            currentLocation = new CtfLocation(0L);
        }
        CtfIterator context = new CtfIterator(this);
        if (currentLocation.getLocation() == CtfLocation.INVALID_LOCATION) {
            ((CtfTmfTimestamp)this.getEndTime()).setType(CtfTmfTimestamp.TimestampType.NANOS);
            currentLocation.setLocation(this.getEndTime().getValue() + 1L);
        }
        context.setLocation((ITmfLocation<?>)currentLocation);
        context.setRank(-1L);
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfIterator iterator = new CtfIterator(this);
        iterator.seek(curLocation.getLocation());
        return ((double)iterator.getCurrentEvent().getTimestampValue() - (double)iterator.getStartTime()) / (double)(iterator.getEndTime() - iterator.getStartTime());
    }

    @Override
    public long getStreamingInterval() {
        return 0L;
    }

    @Override
    public ITmfContext seekEvent(ITmfTimestamp timestamp) {
        CtfIterator context = new CtfIterator(this);
        context.seek(timestamp.getValue());
        context.setRank(-1L);
        return context;
    }

    @Override
    public ITmfContext seekEvent(long rank) {
        CtfIterator context = new CtfIterator(this);
        context.seekRank(rank);
        context.setRank(rank);
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        CtfIterator context = new CtfIterator(this);
        context.seek((long)((double)this.fNbEvents * ratio));
        context.setRank(-1L);
        return context;
    }

    @Override
    public CtfTmfEvent getNext(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfIterator) {
            CtfIterator ctfIterator = (CtfIterator)context;
            event = ctfIterator.getCurrentEvent();
            ctfIterator.advance();
        }
        return event;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    public IStateSystemQuerier getStateSystem() {
        return this.ss;
    }

    CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    protected void buildStateSystem() throws TmfTraceException {
    }
}

