/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.profiling.launch.LocalFileProxy;
import org.eclipse.linuxtools.internal.profiling.launch.LocalLauncher;
import org.eclipse.linuxtools.internal.profiling.launch.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteProxyManager;

public class RemoteProxyManager
implements IRemoteProxyManager {
    private static final String EXT_ATTR_CLASS = "class";
    private static final String LocalHost = "LOCALHOST";
    private static RemoteProxyManager manager;
    private LocalFileProxy lfp;
    private Map<String, IRemoteProxyManager> remoteManagers = new HashMap<String, IRemoteProxyManager>();

    private RemoteProxyManager() {
    }

    public static RemoteProxyManager getInstance() {
        if (manager == null) {
            manager = new RemoteProxyManager();
        }
        return manager;
    }

    LocalFileProxy getLocalFileProxy() {
        if (this.lfp == null) {
            this.lfp = new LocalFileProxy();
        }
        return this.lfp;
    }

    private IRemoteProxyManager getRemoteManager(String schemeId) throws CoreException {
        IRemoteProxyManager remoteManager = this.remoteManagers.get(schemeId);
        if (remoteManager == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.profiling.launch", "RemoteProxyManager");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < infos.length) {
                Object obj;
                IConfigurationElement configurationElement = infos[i];
                if (configurationElement.getName().equals("manager") && configurationElement.getAttribute("scheme").equals(schemeId) && (obj = configurationElement.createExecutableExtension(EXT_ATTR_CLASS)) instanceof IRemoteProxyManager) {
                    remoteManager = (IRemoteProxyManager)obj;
                    this.remoteManagers.put(schemeId, remoteManager);
                    break;
                }
                ++i;
            }
        }
        return remoteManager;
    }

    public IRemoteFileProxy getFileProxy(URI uri) throws CoreException {
        String scheme = uri.getScheme();
        if (scheme != null && !LocalHost.equals(uri.getHost())) {
            IRemoteProxyManager manager = this.getRemoteManager(scheme);
            if (manager != null) {
                return manager.getFileProxy(uri);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.profiling.launch", 0, String.valueOf(Messages.RemoteProxyManager_unrecognized_scheme) + scheme, null));
        }
        return this.getLocalFileProxy();
    }

    public IRemoteFileProxy getFileProxy(IProject project) throws CoreException {
        URI projectURI = project.getLocationURI();
        return this.getFileProxy(projectURI);
    }

    public IRemoteCommandLauncher getLauncher(URI uri) throws CoreException {
        IRemoteProxyManager manager;
        String scheme = uri.getScheme();
        if (scheme != null && !LocalHost.equals(uri.getHost()) && (manager = this.getRemoteManager(scheme)) != null) {
            return manager.getLauncher(uri);
        }
        return new LocalLauncher();
    }

    public IRemoteCommandLauncher getLauncher(IProject project) throws CoreException {
        URI projectURI = project.getLocationURI();
        return this.getLauncher(projectURI);
    }

    public String getOS(URI uri) throws CoreException {
        IRemoteProxyManager manager;
        String scheme = uri.getScheme();
        if (scheme != null && !LocalHost.equals(uri.getHost()) && (manager = this.getRemoteManager(scheme)) != null) {
            return manager.getOS(uri);
        }
        return Platform.getOS();
    }

    public String getOS(IProject project) throws CoreException {
        URI projectURI = project.getLocationURI();
        return this.getOS(projectURI);
    }
}

