/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency;

import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.AbstractMouseListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.AbstractMouseTrackListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.AbstractPaintListener;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners.ZoomListener;
import org.eclipse.linuxtools.tmf.ui.views.distribution.model.IBaseDistributionModel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractViewer
extends Canvas {
    protected Composite fParent;
    protected AbstractPaintListener fPaintListener;
    protected ZoomListener fZoomListener;
    protected AbstractMouseTrackListener fMouseTraceListener;
    protected AbstractMouseListener fMouseListener;

    public AbstractViewer(Composite parent, int style) {
        super(parent, style);
        this.fParent = parent;
    }

    public abstract void clear();

    public abstract void clearBackground();

    public abstract void increaseBarWidth();

    public abstract void decreaseBarWidth();

    public abstract IBaseDistributionModel getModel();

    public int getZoomFactor() {
        if (this.fZoomListener != null) {
            return this.fZoomListener.getZoomFactor();
        }
        return 1;
    }

    public int getZoomIncrement() {
        if (this.fZoomListener != null) {
            return this.fZoomListener.getZoomIncrement();
        }
        return 1;
    }

    public void setDrawLabelEachNTicks(int nbTicks) {
        this.fPaintListener.setDrawLabelEachNTicks(nbTicks);
    }

    public void setGraphTitle(String graphTitle) {
        this.fPaintListener.setGraphTitle(graphTitle);
    }

    public void setXAxisLabel(String xLabel, int offset) {
        this.fPaintListener.setXAxisLabel(xLabel, offset);
    }

    public void setYAxisLabel(String yLabel) {
        this.fPaintListener.setYAxisLabel(yLabel);
    }

    public void askForRedraw(boolean asyncRedraw) {
        if (asyncRedraw) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractViewer.this.redraw();
                    }
                    catch (SWTException sWTException) {}
                }
            });
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractViewer.this.redraw();
                    }
                    catch (SWTException sWTException) {}
                }
            });
        }
    }

    public void askForRedraw() {
        this.askForRedraw(true);
    }

    public void redrawTitle() {
        this.fPaintListener.paintGraphTitle();
    }

    public void dispose() {
        try {
            if (this.fPaintListener != null) {
                this.removePaintListener(this.fPaintListener);
                this.fPaintListener = null;
            }
            if (this.fZoomListener != null) {
                this.removeListener(37, this.fZoomListener);
                this.fZoomListener = null;
            }
            if (this.fMouseTraceListener != null) {
                this.removeListener(5, (SWTEventListener)this.fMouseTraceListener);
                this.fMouseTraceListener = null;
            }
        }
        catch (SWTException sWTException) {}
        super.dispose();
    }
}

