/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;

public class DeleteAction
extends Action {
    private static final String DELETE_TRACE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.trace.delete";
    private static final String DELETE_EXPERIMENT_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.experiment.delete";
    private IWorkbenchPage page;
    private ISelectionProvider selectionProvider;
    private boolean tracesSelected;
    private boolean experimentsSelected;

    public DeleteAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.page = page;
        this.selectionProvider = selectionProvider;
    }

    public boolean isEnabled() {
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            this.tracesSelected = false;
            this.experimentsSelected = false;
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            for (Object aSelection : sSelection.toList()) {
                if (aSelection instanceof TmfTraceElement) {
                    this.tracesSelected = true;
                }
                if (!(aSelection instanceof TmfExperimentElement)) continue;
                this.experimentsSelected = true;
            }
            if (this.tracesSelected && this.experimentsSelected) {
                return false;
            }
            return this.tracesSelected || this.experimentsSelected;
        }
        return false;
    }

    public void run() {
        try {
            IHandlerService handlerService = (IHandlerService)this.page.getActivePart().getSite().getService(IHandlerService.class);
            if (this.tracesSelected) {
                handlerService.executeCommand(DELETE_TRACE_COMMAND_ID, null);
            } else if (this.experimentsSelected) {
                handlerService.executeCommand(DELETE_EXPERIMENT_COMMAND_ID, null);
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
    }
}

