/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.experiment;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperimentLocation;
import org.eclipse.linuxtools.tmf.core.experiment.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperimentContext
extends TmfContext {
    public static final int NO_TRACE = -1;
    private ITmfTrace<?>[] fTraces = new ITmfTrace[0];
    private TmfContext[] fContexts;
    private ITmfEvent[] fEvents;
    private int lastTraceRead;

    public TmfExperimentContext(ITmfTrace<?>[] traces, TmfContext[] contexts) {
        this.fTraces = traces;
        this.fContexts = contexts;
        this.fEvents = new ITmfEvent[this.fTraces.length];
        ITmfLocation[] locations = new ITmfLocation[this.fTraces.length];
        long[] ranks = new long[this.fTraces.length];
        long rank = 0L;
        int i = 0;
        while (i < this.fTraces.length) {
            if (contexts[i] != null) {
                locations[i] = contexts[i].getLocation();
                ranks[i] = contexts[i].getRank();
                rank += contexts[i].getRank();
            }
            ++i;
        }
        this.setLocation(new TmfExperimentLocation(new TmfLocationArray(locations), ranks));
        this.setRank(rank);
        this.lastTraceRead = -1;
    }

    public TmfExperimentContext(ITmfTrace<?>[] traces) {
        this(traces, new TmfContext[traces.length]);
    }

    public TmfExperimentContext(TmfExperimentContext other) {
        this(other.fTraces, other.cloneContexts());
        this.fEvents = other.fEvents;
        if (other.getLocation() != null) {
            this.setLocation(other.getLocation().clone());
        }
        this.setRank(other.getRank());
        this.setLastTrace(other.lastTraceRead);
    }

    private TmfContext[] cloneContexts() {
        TmfContext[] contexts = new TmfContext[this.fContexts.length];
        int i = 0;
        while (i < this.fContexts.length) {
            contexts[i] = this.fContexts[i].clone();
            ++i;
        }
        return contexts;
    }

    public ITmfTrace<?>[] getTraces() {
        return this.fTraces;
    }

    public ITmfContext[] getContexts() {
        return this.fContexts;
    }

    public ITmfEvent[] getEvents() {
        return this.fEvents;
    }

    public int getLastTrace() {
        return this.lastTraceRead;
    }

    public void setLastTrace(int newIndex) {
        this.lastTraceRead = newIndex;
    }

    @Override
    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fTraces.length) {
            result = 37 * result + this.fTraces[i].hashCode();
            result = 37 * result + this.fContexts[i].hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        boolean isEqual = true;
        int i = 0;
        while (isEqual && i < this.fTraces.length) {
            isEqual &= this.fTraces[i].equals(o.fTraces[i]);
            isEqual &= this.fContexts[i].equals(o.fContexts[i]);
            ++i;
        }
        return isEqual;
    }
}

