/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SourceComparator;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackageContainer;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePreamble;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specfile {
    private SpecfilePreamble preamble;
    private SpecfilePackageContainer packages = new SpecfilePackageContainer();
    private List<SpecfileSection> sections;
    private List<SpecfileSection> complexSections;
    private Map<String, SpecfileDefine> defines;
    private Map<Integer, SpecfileSource> sources;
    private Map<Integer, SpecfileSource> patches;
    private List<SpecfileTag> buildRequires;
    private List<SpecfileTag> requires;
    private IDocument document;

    public Specfile() {
        this.preamble = new SpecfilePreamble();
        this.sections = new ArrayList<SpecfileSection>();
        this.complexSections = new ArrayList<SpecfileSection>();
        this.defines = new HashMap<String, SpecfileDefine>();
        this.sources = new HashMap<Integer, SpecfileSource>();
        this.patches = new HashMap<Integer, SpecfileSource>();
        this.buildRequires = new ArrayList<SpecfileTag>();
        this.requires = new ArrayList<SpecfileTag>();
    }

    public List<SpecfileSection> getSections() {
        return this.sections;
    }

    public SpecfileSection getSection(String sectionName) {
        for (SpecfileSection section : this.sections) {
            if (!sectionName.equals(section.getName())) continue;
            return section;
        }
        return null;
    }

    public List<SpecfileSection> getComplexSections() {
        return this.complexSections;
    }

    public SpecfileSource getPatch(int number) {
        return this.patches.get(number);
    }

    public SpecfileSource getSource(int number) {
        return this.sources.get(number);
    }

    public String getName() {
        SpecfileDefine define = this.getDefine("Name".toLowerCase());
        if (define != null) {
            return define.getStringValue();
        }
        return " ";
    }

    public void addSection(SpecfileSection section) {
        this.sections.add(section);
    }

    public void addComplexSection(SpecfileSection section) {
        this.complexSections.add(section);
    }

    public void addSource(SpecfileSource source) {
        this.sources.put(source.getNumber(), source);
    }

    public void addPatch(SpecfileSource patch) {
        this.patches.put(patch.getNumber(), patch);
    }

    public void addDefine(SpecfileDefine define) {
        SpecfilePackage rpmPackage = define.getParent();
        if (rpmPackage != null && !rpmPackage.isMainPackage()) {
            this.defines.put(UiUtils.getPackageDefineId(define, rpmPackage), define);
            return;
        }
        this.defines.put(define.getName(), define);
    }

    public void addDefine(SpecfileTag tag) {
        this.addDefine(new SpecfileDefine(tag));
    }

    public SpecfileDefine getDefine(String defineName) {
        return this.defines.get(defineName.toLowerCase());
    }

    public SpecfileDefine getDefine(String defineName, SpecfilePackage rpmPackage) {
        return this.defines.get(UiUtils.getPackageDefineId(defineName, rpmPackage));
    }

    public int getEpoch() {
        SpecfileDefine define = this.getDefine("Epoch".toLowerCase());
        if (define != null) {
            return define.getIntValue();
        }
        return -1;
    }

    public String getRelease() {
        SpecfileDefine define = this.getDefine("Release".toLowerCase());
        if (define != null) {
            return define.getStringValue();
        }
        return "0";
    }

    public String getVersion() {
        SpecfileDefine define = this.getDefine("Version".toLowerCase());
        if (define != null) {
            return define.getStringValue();
        }
        return "0";
    }

    public List<SpecfileSource> getPatches() {
        ArrayList<SpecfileSource> patchesList = new ArrayList<SpecfileSource>(this.patches.values());
        Collections.sort(patchesList, new SourceComparator());
        return patchesList;
    }

    public Collection<SpecfileSource> getSources() {
        ArrayList<SpecfileSource> sourcesList = new ArrayList<SpecfileSource>(this.sources.values());
        Collections.sort(sourcesList, new SourceComparator());
        return sourcesList;
    }

    public List<SpecfileDefine> getDefines() {
        ArrayList<SpecfileDefine> definesList = new ArrayList<SpecfileDefine>(this.defines.values());
        return definesList;
    }

    public void organizePatches() {
        List<SpecfileSource> patches = this.getPatches();
        int newPatchNumber = 0;
        int oldPatchNumber = -1;
        HashMap<Integer, SpecfileSource> newPatches = new HashMap<Integer, SpecfileSource>();
        for (SpecfileSource thisPatch : patches) {
            if (thisPatch.getSpecfile() == null) {
                thisPatch.setSpecfile(this);
            }
            oldPatchNumber = thisPatch.getNumber();
            thisPatch.setNumber(newPatchNumber);
            thisPatch.changeDeclaration(oldPatchNumber);
            thisPatch.changeReferences(oldPatchNumber);
            newPatches.put(newPatchNumber, thisPatch);
            ++newPatchNumber;
        }
        this.setPatches(newPatches);
    }

    public void setDocument(IDocument specfileDocument) {
        this.document = specfileDocument;
    }

    public String getLine(int lineNumber) throws BadLocationException {
        int offset = this.document.getLineOffset(lineNumber);
        int length = this.getLineLength(lineNumber);
        String lineContents = this.document.get(offset, length);
        return lineContents;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public int getLineLength(int lineNumber) throws BadLocationException {
        int length = this.document.getLineLength(lineNumber);
        String lineDelimiter = this.document.getLineDelimiter(lineNumber);
        if (lineDelimiter != null) {
            length -= lineDelimiter.length();
        }
        return length;
    }

    public void changeLine(int lineNumber, String string) throws BadLocationException {
        this.document.replace(this.document.getLineOffset(lineNumber), this.getLineLength(lineNumber), string);
    }

    public void setPatches(Map<Integer, SpecfileSource> patches) {
        this.patches = patches;
    }

    public String toString() {
        return this.getName();
    }

    public String getLicense() {
        return this.defines.get("License".toLowerCase()).getStringValue();
    }

    public SpecfilePackageContainer getPackages() {
        return this.packages;
    }

    public SpecfileElement getPreamble() {
        return this.preamble;
    }

    public SpecfilePackage getPackage(String packageName) {
        return this.getPackages().getPackage(packageName);
    }

    public void addPackage(SpecfilePackage subPackage) {
        if (!this.packages.contains(subPackage)) {
            this.packages.addPackage(subPackage);
        }
    }

    public void modifyDefine(String defineName, SpecfilePackage rpmPackage, String newValue) {
        SpecfileDefine define = this.getDefine(UiUtils.getPackageDefineId(defineName, rpmPackage));
        if (define != null) {
            define.setValue(newValue);
            try {
                this.changeLine(define.getLineNumber(), String.valueOf(defineName) + ": " + newValue);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void modifyDefine(String defineName, String newValue) {
        SpecfileDefine define = this.getDefine(defineName.toLowerCase());
        if (define != null) {
            define.setValue(newValue);
            try {
                this.changeLine(define.getLineNumber(), String.valueOf(defineName) + ": " + newValue);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void modifyDefine(SpecfileTag define, String newValue) {
        if (define != null) {
            define.setValue(newValue);
            try {
                this.changeLine(define.getLineNumber(), String.valueOf(define.getName()) + ": " + newValue);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void addBuildRequire(SpecfileDefine buildRequire) {
        this.buildRequires.add(buildRequire);
    }

    public void addRequire(SpecfileTag require) {
        this.requires.add(require);
    }

    public List<SpecfileTag> getBuildRequires() {
        return this.buildRequires;
    }

    public List<SpecfileTag> getRequires() {
        return this.requires;
    }
}

