/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.rpm.ui.editor.preferences.Messages;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.linuxtools.rpm.ui.editor.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RpmProposalsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FieldEditor rpmtools;

    public RpmProposalsPreferencePage() {
        super(0);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        this.rpmtools = this.rpmtoolsRadioGroupFieldEditor();
        this.addField(this.rpmtools);
        StringFieldEditor rpmListFieldEditor = new StringFieldEditor("rpmListFilePath", Messages.RpmProposalsPreferencePage_0, this.getFieldEditorParent());
        this.addField((FieldEditor)rpmListFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("rpmListBackgroundBuild", Messages.RpmProposalsPreferencePage_1, this.getFieldEditorParent()));
        this.addField(this.buildTimeListRateFieldEditor());
    }

    protected Control createContents(final Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.RpmProposalsPreferencePage_2);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        Composite fieldEditorComposite = (Composite)super.createContents(parent);
        return fieldEditorComposite;
    }

    private FieldEditor rpmtoolsRadioGroupFieldEditor() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{Messages.RpmProposalsPreferencePage_3, "rpm -qa --qf '%{NAME}\\n'"});
        if (Utils.fileExist((String)"/usr/bin/yum")) {
            list.add(new String[]{Messages.RpmProposalsPreferencePage_4, "yum -C list all | grep - | cut -d \".\" -f 1"});
        }
        if (Utils.fileExist((String)"/usr/bin/urpmq")) {
            list.add(new String[]{Messages.RpmProposalsPreferencePage_5, "urpmq --list"});
        }
        String[][] radioItems = new String[list.size()][2];
        int pos = 0;
        for (String[] item : list) {
            radioItems[pos][0] = item[0];
            radioItems[pos][1] = item[1];
            ++pos;
        }
        RadioGroupFieldEditor rpmToolsRadioGroupEditor = new RadioGroupFieldEditor("currentRpmtools", Messages.RpmProposalsPreferencePage_6, 1, radioItems, this.getFieldEditorParent(), true);
        return rpmToolsRadioGroupEditor;
    }

    private FieldEditor buildTimeListRateFieldEditor() {
        RadioGroupFieldEditor buildListTimeRateRadioGroupEditor = new RadioGroupFieldEditor("rpmListBuildPeriod", Messages.RpmProposalsPreferencePage_7, 1, (String[][])new String[][]{{Messages.RpmProposalsPreferencePage_8, "1"}, {Messages.RpmProposalsPreferencePage_10, "2"}, {Messages.RpmProposalsPreferencePage_12, "3"}}, this.getFieldEditorParent(), true);
        return buildListTimeRateRadioGroupEditor;
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource().equals(this.rpmtools) && !event.getOldValue().equals(event.getNewValue())) {
            String rpmpkgsFile = Activator.getDefault().getPreferenceStore().getString("rpmListFilePath");
            if (Utils.fileExist((String)rpmpkgsFile)) {
                new File(rpmpkgsFile).delete();
            }
            Activator.packagesList = null;
        }
    }
}

