/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfilePartitioner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class SpecfileDocumentProvider
extends TextFileDocumentProvider {
    private IDocument document;
    private int originalLength;

    private void setDocumentLength(Object element) {
        IDocument doc = this.getDocument(element);
        this.originalLength = doc == null ? 0 : doc.getLength();
    }

    public IDocument getDocument(Object element) {
        this.document = super.getDocument(element);
        if (this.document != null && this.document.getDocumentPartitioner() == null) {
            SpecfilePartitioner partitioner = new SpecfilePartitioner((IPartitionTokenScanner)new SpecfilePartitionScanner(), SpecfilePartitionScanner.SPEC_PARTITION_TYPES);
            partitioner.connect(this.document, false);
            this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return this.document;
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        this.setDocumentLength(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canSaveDocument(Object element) {
        if (!(element instanceof FileStoreEditorInput)) {
            return super.canSaveDocument(element);
        }
        FileStoreEditorInput fei = (FileStoreEditorInput)element;
        IDocument doc = this.getDocument(element);
        if (!super.canSaveDocument(element)) {
            return false;
        }
        if (doc.getLength() != this.originalLength) {
            return true;
        }
        URI uri = fei.getURI();
        File f = URIUtil.toFile((URI)uri);
        try {
            if (this.originalLength != 0) {
                int len;
                BufferedReader input = new BufferedReader(new FileReader(f));
                boolean finished = false;
                char[] buffer = new char[100];
                int curoffset = 0;
                while (!finished && (len = input.read(buffer)) > 0) {
                    String origbytes = new String(buffer, 0, len);
                    String curbytes = doc.get(curoffset, len);
                    if (!curbytes.equals(origbytes)) {
                        return true;
                    }
                    curoffset += len;
                }
            }
            this.resetDocument(element);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.DocumentProviderOperation saveOperation = super.createSaveOperation(element, document, overwrite);
        if (element instanceof IURIEditorInput) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    saveOperation.run(monitor);
                    SpecfileDocumentProvider.this.setDocumentLength(element);
                }

                public ISchedulingRule getSchedulingRule() {
                    return saveOperation.getSchedulingRule();
                }
            };
        }
        return saveOperation;
    }
}

