/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.swt.graphics.Image;

public class UiModelDependent
implements IUiModelElement {
    private IUiModelElement _parent;
    private OpModelImage[] _dataModelDependents;
    private UiModelImage[] _dependents;
    private int _totalCount;
    private int _depCount;

    public UiModelDependent(IUiModelElement parent, OpModelImage[] dependents, int totalCount, int depCount) {
        this._parent = parent;
        this._dataModelDependents = dependents;
        this._dependents = null;
        this._totalCount = totalCount;
        this._depCount = depCount;
        this.refreshModel();
    }

    private void refreshModel() {
        this._dependents = new UiModelImage[this._dataModelDependents.length];
        int i = 0;
        while (i < this._dataModelDependents.length) {
            this._dependents[i] = new UiModelImage(this, this._dataModelDependents[i], this._totalCount, 0);
            ++i;
        }
    }

    public String toString() {
        double countPercentage = (double)this._depCount / (double)this._totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + OprofileUiMessages.getString("uimodel.dependent.dependent.images");
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        return this._dependents;
    }

    public boolean hasChildren() {
        return true;
    }

    public IUiModelElement getParent() {
        return this._parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/dependent.gif").createImage();
    }
}

