/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.controlflow;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.internal.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.AbsTimeUpdateView;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.internal.lttng.ui.views.controlflow.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.controlflow.evProcessor.FlowEventToHandlerFactory;
import org.eclipse.linuxtools.internal.lttng.ui.views.controlflow.model.FlowModelFactory;
import org.eclipse.linuxtools.internal.lttng.ui.views.controlflow.model.FlowTimeRangeViewerProvider;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.TmfViewerFactory;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeFilterSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeScaleSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeFilterSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ControlFlowView
extends AbsTimeUpdateView
implements ITmfTimeSelectionListener,
ITmfTimeScaleSelectionListener,
ITmfTimeFilterSelectionListener {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.controlflow";
    private final String PROCESS_COLUMN = Messages.getString("ControlFlowView.processColumn");
    private final String BRAND_COLUMN = Messages.getString("ControlFlowView.brandColumn");
    private final String PID_COLUMN = Messages.getString("ControlFlowView.pidColumn");
    private final String TGID_COLUMN = Messages.getString("ControlFlowView.tgidColumn");
    private final String PPID_COLUMN = Messages.getString("ControlFlowView.ppidColumn");
    private final String CPU_COLUMN = Messages.getString("ControlFlowView.cpuColumn");
    private final String BIRTH_SEC_COLUMN = Messages.getString("ControlFlowView.birthSecColumn");
    private final String BIRTH_NSEC_COLUMN = Messages.getString("ControlFlowView.birthNSecColumn");
    private final String TRACE = Messages.getString("ControlFlowView.TraceNameColumn");
    private final String[] columnNames = new String[]{this.PROCESS_COLUMN, this.BRAND_COLUMN, this.PID_COLUMN, this.TGID_COLUMN, this.PPID_COLUMN, this.CPU_COLUMN, this.BIRTH_SEC_COLUMN, this.BIRTH_NSEC_COLUMN, this.TRACE};
    private TableViewer tableViewer;
    private Action resetScale;
    private Action nextEvent;
    private Action prevEvent;
    private Action nextTrace;
    private Action prevTrace;
    private Action showLegend;
    private Action filterTraces;
    private Action zoomIn;
    private Action zoomOut;
    private Action zoomFilter;
    private ViewProcessFilter tableFilter = null;
    private TmfTimeRange initTimeRange = TmfTimeRange.NULL_RANGE;
    private static final Object FILLER = new Object();
    private static int numFillerRows;

    public ControlFlowView() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 0);
        this.tableViewer = new TableViewer((Composite)sash, 65792);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider(this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        Table table = this.tableViewer.getTable();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (!sel.isEmpty()) {
                    Object firstSel = null;
                    if (sel instanceof IStructuredSelection) {
                        firstSel = ((IStructuredSelection)sel).getFirstElement();
                        if (firstSel instanceof ITmfTimeAnalysisEntry) {
                            ITmfTimeAnalysisEntry trace = (ITmfTimeAnalysisEntry)firstSel;
                            ControlFlowView.this.tsfviewer.setSelectedTrace(trace);
                            int selection = ControlFlowView.this.tsfviewer.getVerticalBar().getSelection();
                            ControlFlowView.this.tableViewer.getTable().setTopIndex(selection);
                        } else if (firstSel == FILLER) {
                            Table table = ControlFlowView.this.tableViewer.getTable();
                            table.select(table.getItemCount() - 1 - numFillerRows);
                            Object selectedItem = ((IStructuredSelection)ControlFlowView.this.tableViewer.getSelection()).getFirstElement();
                            if (selectedItem instanceof ITmfTimeAnalysisEntry) {
                                ControlFlowView.this.tsfviewer.setSelectedTrace((ITmfTimeAnalysisEntry)selectedItem);
                                int selection = ControlFlowView.this.tsfviewer.getVerticalBar().getSelection();
                                ControlFlowView.this.tableViewer.getTable().setTopIndex(selection);
                            }
                        }
                    }
                }
            }
        });
        table.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                ScrollBar scrollBar = ControlFlowView.this.tsfviewer.getVerticalBar();
                ControlFlowView.this.tsfviewer.setTopIndex(scrollBar.getSelection() - e.count);
                ControlFlowView.this.tableViewer.getTable().setTopIndex(scrollBar.getSelection());
            }
        });
        this.applyTableLayout(table);
        int borderWidth = table.getBorderWidth();
        int itemHeight = table.getItemHeight() + this.getTableItemHeightAdjustement();
        int headerHeight = table.getHeaderHeight();
        table.getVerticalBar().setVisible(false);
        numFillerRows = Display.getDefault().getBounds().height / itemHeight;
        this.tsfviewer = TmfViewerFactory.createViewer((Composite)sash, (TmfTimeAnalysisProvider)new FlowTimeRangeViewerProvider(this.getParamsUpdater()));
        this.tsfviewer.groupTraces(false);
        this.tsfviewer.setItemHeight(itemHeight);
        this.tsfviewer.setBorderWidth(borderWidth);
        this.tsfviewer.setHeaderHeight(headerHeight);
        this.tsfviewer.setNameWidthPref(0);
        this.tsfviewer.setAcceptSelectionAPIcalls(true);
        this.tsfviewer.addWidgetSelectionListner((ITmfTimeSelectionListener)this);
        this.tsfviewer.addFilterSelectionListner((ITmfTimeFilterSelectionListener)this);
        this.tsfviewer.addWidgetTimeScaleSelectionListner((ITmfTimeScaleSelectionListener)this);
        this.tsfviewer.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollBar scrollBar = (ScrollBar)e.widget;
                int selection = scrollBar.getSelection();
                ControlFlowView.this.tableViewer.getTable().setTopIndex(selection);
            }
        });
        this.tsfviewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int selection = ControlFlowView.this.tsfviewer.getVerticalBar().getSelection();
                ControlFlowView.this.tableViewer.getTable().setTopIndex(selection);
            }
        });
        sash.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.eclipse.linuxtools.lttnng.ui.views.flow.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null) {
            TmfTimeRange experimentTRange = experiment.getTimeRange();
            if (experimentTRange != TmfTimeRange.NULL_RANGE) {
                TmfTimeRange adjustedTimeRange = this.initialExperimentDataRequest((Object)this, experimentTRange);
                this.modelUpdateInit(experimentTRange, adjustedTimeRange, (Object)this);
            }
        } else {
            TraceDebug.debug("No selected experiment information available");
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ControlFlowView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.showLegend);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.resetScale = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.resetStartFinishTime();
                }
            }
        };
        this.resetScale.setText(Messages.getString("ControlFlowView.Action.Reset"));
        this.resetScale.setToolTipText(Messages.getString("ControlFlowView.Action.Reset.ToolTip"));
        this.resetScale.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/home_nav.gif"));
        this.nextEvent = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectNextEvent();
                }
            }
        };
        this.nextEvent.setText(Messages.getString("ControlFlowView.Action.NextEvent"));
        this.nextEvent.setToolTipText(Messages.getString("ControlFlowView.Action.NextEvent.Tooltip"));
        this.nextEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/next_event.gif"));
        this.prevEvent = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectPrevEvent();
                }
            }
        };
        this.prevEvent.setText(Messages.getString("ControlFlowView.Action.PrevEvent"));
        this.prevEvent.setToolTipText(Messages.getString("ControlFlowView.Action.PrevEvent.Tooltip"));
        this.prevEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/prev_event.gif"));
        this.nextTrace = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectNextTrace();
                }
            }
        };
        this.nextTrace.setText(Messages.getString("ControlFlowView.Action.NextProcess"));
        this.nextTrace.setToolTipText(Messages.getString("ControlFlowView.Action.NextProcess.ToolTip"));
        this.nextTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/next_item.gif"));
        this.prevTrace = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectPrevTrace();
                }
            }
        };
        this.prevTrace.setText(Messages.getString("ControlFlowView.Action.PreviousProcess"));
        this.prevTrace.setToolTipText(Messages.getString("ControlFlowView.Action.PreviousProcess.Tooltip"));
        this.prevTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/prev_item.gif"));
        this.showLegend = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.showLegend();
                }
            }
        };
        this.showLegend.setText(Messages.getString("ControlFlowView.Action.Legend"));
        this.showLegend.setToolTipText(Messages.getString("ControlFlowView.Action.Legend.ToolTip"));
        this.filterTraces = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.filterTraces();
                }
            }
        };
        this.filterTraces.setText(Messages.getString("ControlFlowView.Action.Filter"));
        this.filterTraces.setToolTipText(Messages.getString("ControlFlowView.Action.Filter.ToolTip"));
        this.filterTraces.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomIn = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.zoomIn();
                }
            }
        };
        this.zoomIn.setText(Messages.getString("ControlFlowView.Action.ZoomIn"));
        this.zoomIn.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomIn.Tooltip"));
        this.zoomIn.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/zoomin_nav.gif"));
        this.zoomOut = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.zoomOut();
                }
            }
        };
        this.zoomOut.setText(Messages.getString("ControlFlowView.Action.ZoomOut"));
        this.zoomOut.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomOut.tooltip"));
        this.zoomOut.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/zoomout_nav.gif"));
        this.zoomFilter = new Action(){

            public void run() {
            }
        };
        this.zoomFilter.setText(Messages.getString("ControlFlowView.Action.ZoomFilter"));
        this.zoomFilter.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomFilter.tooltip"));
        this.zoomFilter.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomFilter.setChecked(false);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    @Override
    public void tsfTmProcessSelEvent(TmfTimeSelectionEvent event) {
        super.tsfTmProcessSelEvent(event);
        ISelection sel = this.tsfviewer.getSelectionTrace();
        if (sel != null && !sel.isEmpty()) {
            this.tableViewer.setSelection(sel);
        }
    }

    @Override
    public void tsfTmProcessTimeScaleEvent(TmfTimeScaleSelectionEvent event) {
        super.tsfTmProcessTimeScaleEvent(event);
    }

    private void applyTableLayout(Table table) {
        int i = 0;
        while (i < this.columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(this.columnNames[i]);
            tableColumn.pack();
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    @Override
    public void displayModel(final ITmfTimeAnalysisEntry[] items, final long startBoundTime, final long endBoundTime, final boolean updateTimeBounds, final long startVisibleWindow, final long endVisibleWindow, final Object source) {
        if (this.tableViewer != null) {
            final Table table = this.tableViewer.getTable();
            if (table.isDisposed()) {
                return;
            }
            Display display = table.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!table.isDisposed()) {
                        ControlFlowView.this.tableViewer.setInput((Object)items);
                        ControlFlowView.this.tableFilter = new ViewProcessFilter((StructuredViewer)ControlFlowView.this.tableViewer);
                        ControlFlowView.this.tableViewer.setFilters(new ViewerFilter[]{ControlFlowView.this.tableFilter});
                        ControlFlowView.this.resizeTableColumns(table);
                        table.update();
                        ControlFlowView.this.tableViewer.refresh();
                        ControlFlowView.this.tsfviewer.display(items, startBoundTime, endBoundTime, updateTimeBounds);
                        if (startVisibleWindow > -1L && endVisibleWindow > -1L) {
                            ControlFlowView.this.tsfviewer.setSelectVisTimeWindow(startVisibleWindow, endVisibleWindow, source);
                        }
                        ControlFlowView.this.tsfviewer.resizeControls();
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.tsfviewer.removeFilterSelectionListner((ITmfTimeFilterSelectionListener)this);
        this.tsfviewer.removeWidgetSelectionListner((ITmfTimeSelectionListener)this);
        this.tsfviewer.removeWidgetTimeScaleSelectionListner((ITmfTimeScaleSelectionListener)this);
        this.tableViewer = null;
        this.tsfviewer = null;
    }

    private synchronized void resizeTableColumns(Table table) {
        if (table != null) {
            TableColumn[] columns;
            TableColumn[] tableColumnArray = columns = table.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
        }
    }

    public void tmfTaProcessFilterSelection(TmfTimeFilterSelectionEvent event) {
        if (this.tableFilter != null) {
            Vector filteredout = event.getFilteredOut();
            if (filteredout != null) {
                this.tableFilter.setFilter(filteredout);
            } else {
                this.tableFilter.setFilter(new Vector<ITmfTimeAnalysisEntry>());
            }
            this.tableViewer.refresh();
        }
    }

    @Override
    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        super.synchToTime(signal);
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        if (this.zoomFilter != null) {
            this.synchToTimeRange(signal, this.zoomFilter.isChecked());
        }
    }

    @Override
    public void modelIncomplete(ILttngSyntEventRequest request) {
    }

    @Override
    public ITransEventProcessor getEventProcessor() {
        return FlowEventToHandlerFactory.getInstance();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<? extends TmfEvent> signal) {
        if (signal != null) {
            TmfTimeRange experimentTRange = signal.getExperiment().getTimeRange();
            this.initTimeRange = TmfTimeRange.NULL_RANGE;
            if (experimentTRange != TmfTimeRange.NULL_RANGE) {
                this.modelUpdateInit(experimentTRange, experimentTRange, signal.getSource());
                this.initialExperimentDataRequest(signal.getSource(), experimentTRange);
            }
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfTimeRange experimentTRange;
        if (this.initTimeRange == TmfTimeRange.NULL_RANGE && signal.getExperiment().equals(TmfExperiment.getCurrentExperiment()) && (experimentTRange = signal.getRange()) != TmfTimeRange.NULL_RANGE) {
            this.modelUpdateInit(experimentTRange, experimentTRange, signal.getSource());
            this.initialExperimentDataRequest(signal.getSource(), experimentTRange);
        }
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
        TmfTimeRange range;
        if (signal.getExperiment().equals(TmfExperiment.getCurrentExperiment()) && (range = signal.getExperiment().getTimeRange()) != TmfTimeRange.NULL_RANGE) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ControlFlowView.this.tsfviewer.setTimeBounds(range.getStartTime().getValue(), range.getEndTime().getValue());
                }
            });
        }
    }

    private TmfTimeRange initialExperimentDataRequest(Object source, TmfTimeRange experimentTRange) {
        TmfTimeRange initTimeWindow = this.getInitTRange(experimentTRange);
        this.eventRequest(initTimeWindow, experimentTRange, true, ITmfDataRequest.ExecutionType.FOREGROUND);
        if (TraceDebug.isDEBUG()) {
            TraceDebug.debug("Initialization request time range is: " + initTimeWindow.getStartTime().toString() + "-" + initTimeWindow.getEndTime().toString());
        }
        this.initTimeRange = initTimeWindow;
        return initTimeWindow;
    }

    private int getTableItemHeightAdjustement() {
        int ajustement = 0;
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.equals("kde")) {
            ajustement = 2;
        }
        return ajustement;
    }

    @Override
    protected ParamsUpdater getParamsUpdater() {
        return FlowModelFactory.getParamsUpdater();
    }

    @Override
    protected ItemContainer<?> getItemContainer() {
        return FlowModelFactory.getProcContainer();
    }

    @Override
    protected int getProviderId() {
        return 1;
    }

    static class ViewContentProvider
    implements IStructuredContentProvider {
        private TableViewer cviewer = null;
        private ITmfTimeAnalysisEntry[] elements = null;

        public ViewContentProvider(TableViewer v) {
            this.cviewer = v;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.elements = (ITmfTimeAnalysisEntry[])newInput;
            if (this.elements != null) {
                TraceDebug.debug("Total number of processes provided to Control Flow view: " + this.elements.length);
            } else {
                TraceDebug.debug("New input = null");
            }
        }

        public void dispose() {
        }

        public void updateElement(int index) {
            this.cviewer.replace((Object)this.elements[index], index);
        }

        public Object[] getElements(Object inputElement) {
            Object[] oElements = Arrays.copyOf(this.elements, this.elements.length + numFillerRows, new Object[0].getClass());
            int i = 0;
            while (i < numFillerRows) {
                oElements[this.elements.length + i] = FILLER;
                ++i;
            }
            return oElements;
        }
    }

    static class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String strRes = "";
            if (obj instanceof TimeRangeEventProcess) {
                TimeRangeEventProcess process = (TimeRangeEventProcess)obj;
                switch (index) {
                    case 0: {
                        strRes = process.getName();
                        break;
                    }
                    case 1: {
                        strRes = process.getBrand();
                        break;
                    }
                    case 2: {
                        strRes = process.getPid().toString();
                        break;
                    }
                    case 3: {
                        strRes = process.getTgid().toString();
                        break;
                    }
                    case 4: {
                        strRes = process.getPpid().toString();
                        break;
                    }
                    case 5: {
                        strRes = process.getCpu().toString();
                        break;
                    }
                    case 6: {
                        LttngTimestamp time = new LttngTimestamp(process.getCreationTime().longValue());
                        strRes = time.getSeconds();
                        break;
                    }
                    case 7: {
                        LttngTimestamp time = new LttngTimestamp(process.getCreationTime().longValue());
                        strRes = time.getNanoSeconds();
                        break;
                    }
                    case 8: {
                        strRes = process.getTraceID();
                        break;
                    }
                }
            } else {
                if (obj == FILLER) {
                    return "";
                }
                return this.getText(obj);
            }
            return strRes;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    static class ViewProcessFilter
    extends ViewerFilter {
        private Vector<ITmfTimeAnalysisEntry> filteredSet = new Vector();
        StructuredViewer viewer;

        public ViewProcessFilter(StructuredViewer rviewer) {
            this.viewer = rviewer;
        }

        public void setFilter(Vector<ITmfTimeAnalysisEntry> filtered) {
            if (filtered != null) {
                this.filteredSet = filtered;
                this.viewer.refresh();
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean filteredIn = true;
            if (element instanceof ITmfTimeAnalysisEntry) {
                ITmfTimeAnalysisEntry process = (ITmfTimeAnalysisEntry)element;
                if (this.filteredSet.contains(process)) {
                    return false;
                }
            } else {
                if (element == FILLER) {
                    return true;
                }
                TraceDebug.debug("Unexpected type of filter element received: " + element.toString());
            }
            return filteredIn;
        }
    }
}

