/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.common;

import java.util.Arrays;
import org.eclipse.linuxtools.internal.lttng.core.control.LttngCoreProviderFactory;
import org.eclipse.linuxtools.internal.lttng.core.control.LttngSyntheticEventProvider;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.request.IRequestStatusListener;
import org.eclipse.linuxtools.internal.lttng.core.request.LttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.request.RequestCompletedSignal;
import org.eclipse.linuxtools.internal.lttng.core.request.RequestStartedSignal;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.internal.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITimeAnalysisViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.widgets.Display;

public abstract class AbsTimeUpdateView
extends TmfView
implements IRequestStatusListener {
    private static final long INITIAL_WINDOW_OFFSET = 100000000L;
    protected static final Long INPUT_CHANGED_REFRESH = 75000L;
    private static final long DEFAULT_OFFSET = 0L;
    protected boolean synch = true;
    protected ITimeAnalysisViewer tsfviewer = null;
    private LttngSyntEventRequest fCurrentRequest = null;
    protected LttngSyntheticEventProvider fProvider = LttngCoreProviderFactory.getEventProvider((int)this.getProviderId());

    public AbsTimeUpdateView(String viewID) {
        super(viewID);
    }

    protected Long getInputChangedRefresh() {
        return INPUT_CHANGED_REFRESH;
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<? extends TmfEvent> experimentDisposedSignal) {
        if (experimentDisposedSignal.getExperiment() != TmfExperiment.getCurrentExperiment()) {
            return;
        }
        this.fProvider.conditionallyCancelRequests();
    }

    @TmfSignalHandler
    public synchronized void processingStarted(RequestStartedSignal signal) {
        LttngSyntEventRequest request = signal.getRequest();
        if (request != null) {
            this.waitCursor(true);
            TmfTimeRange trange = null;
            trange = request.getRange();
            boolean clearData = request.isclearDataInd();
            this.modelUpdatePrep(trange, clearData);
        }
    }

    @TmfSignalHandler
    public void processingCompleted(RequestCompletedSignal signal) {
        LttngSyntEventRequest request = signal.getRequest();
        if (request == null) {
            return;
        }
        this.waitCursor(false);
        if (request.isCancelled() || request.isFailed()) {
            if (TraceDebug.isDEBUG()) {
                TmfTimeRange trange = request.getRange();
                if (request.isCancelled()) {
                    TraceDebug.debug("Request cancelled " + trange.getStartTime() + "-" + trange.getEndTime() + " Handled Events: " + request.getSynEventCount() + " " + request.toString(), 15);
                } else if (request.isFailed()) {
                    TraceDebug.debug("Request Failed " + trange.getStartTime() + "-" + trange.getEndTime() + " Handled Events: " + request.getSynEventCount() + " " + request.toString());
                }
            }
            return;
        }
        this.modelInputChanged((ILttngSyntEventRequest)request, true);
    }

    public void synchToTime(TmfTimeSynchSignal signal) {
        Object source;
        if (signal == null) {
            return;
        }
        if (this.synch && (source = signal.getSource()) != null && source != this && this.tsfviewer != null && !this.tsfviewer.getControl().isDisposed()) {
            if (Display.getCurrent() != null) {
                long selectedTime = signal.getCurrentTime().getValue();
                if (this.tsfviewer != null) {
                    this.tsfviewer.setSelectedTime(selectedTime, true, source);
                    ParamsUpdater paramUpdater = this.getParamsUpdater();
                    Long savedSelTime = paramUpdater.getSelectedTime();
                    if (savedSelTime == null || savedSelTime != selectedTime) {
                        paramUpdater.setSelectedTime(selectedTime);
                    }
                }
            } else {
                final TmfTimeSynchSignal savedSignal = new TmfTimeSynchSignal(signal.getSource(), signal.getCurrentTime().clone());
                this.tsfviewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbsTimeUpdateView.this.tsfviewer != null && !AbsTimeUpdateView.this.tsfviewer.getControl().isDisposed()) {
                            AbsTimeUpdateView.this.synchToTime(savedSignal);
                        }
                    }
                });
            }
        }
    }

    public void synchToTimeRange(TmfRangeSynchSignal signal, boolean clearingData) {
        Object source;
        if (signal == null) {
            return;
        }
        if (this.synch && (source = signal.getSource()) != null && source != this) {
            TmfTimeRange trange = signal.getCurrentRange();
            TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
            if (experiment == null) {
                TraceDebug.debug("Current selected experiment is null");
                return;
            }
            this.eventRequest(trange, experiment.getTimeRange(), clearingData, ITmfDataRequest.ExecutionType.FOREGROUND);
        }
    }

    protected void synchTimeNotification(long time, Object source) {
        if (this.synch) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeSynchSignal(source, (ITmfTimestamp)new LttngTimestamp(time)));
        }
    }

    protected void tsfTmProcessSelEvent(TmfTimeSelectionEvent event) {
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        ParamsUpdater paramUpdater = this.getParamsUpdater();
        Long savedSelTime = paramUpdater.getSelectedTime();
        long selTimens = event.getSelectedTime();
        if (savedSelTime == null || savedSelTime != selTimens) {
            this.synchTimeNotification(selTimens, source);
            paramUpdater.setSelectedTime(selTimens);
            if (TraceDebug.isDEBUG()) {
                TraceDebug.debug("Selected Time: " + new LttngTimestamp(selTimens) + "\n\t\t" + this.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tsfTmProcessTimeScaleEvent(TmfTimeScaleSelectionEvent event) {
        Object source = event.getSource();
        boolean newParams = false;
        TmfTimeRange trange = null;
        Long selectedTime = null;
        AbsTimeUpdateView absTimeUpdateView = this;
        synchronized (absTimeUpdateView) {
            ParamsUpdater paramUpdater;
            if (source != null && (newParams = (paramUpdater = this.getParamsUpdater()).processTimeScaleEvent(event)) && (trange = paramUpdater.getTrange()) != null) {
                selectedTime = paramUpdater.getSelectedTime();
            }
        }
        if (selectedTime != null) {
            this.synchTimeRangeNotification(trange, selectedTime, source);
        }
    }

    protected void synchTimeRangeNotification(TmfTimeRange trange, Long selectedTime, Object source) {
        if (this.synch) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfRangeSynchSignal(source, trange, (ITmfTimestamp)new LttngTimestamp(selectedTime.longValue())));
        }
    }

    public void eventRequest(TmfTimeRange zoomedTRange, TmfTimeRange experimentTRange, boolean clearingData, ITmfDataRequest.ExecutionType execType) {
        boolean sent = this.processDataRequest(zoomedTRange, experimentTRange, 0L, Integer.MAX_VALUE, clearingData, execType);
        if (sent) {
            this.waitCursor(true);
        }
    }

    public void eventRequest(long offset, TmfTimeRange range, boolean clearingData, ITmfDataRequest.ExecutionType execType) {
        boolean sent = this.processDataRequest(range, null, offset, Integer.MAX_VALUE, clearingData, execType);
        if (sent) {
            this.waitCursor(true);
        }
    }

    private boolean processDataRequest(TmfTimeRange requestTrange, TmfTimeRange experimentTRange, long offset, int nbRequested, boolean clearingData, ITmfDataRequest.ExecutionType execType) {
        if (requestTrange == null) {
            TraceDebug.debug("Invalid input");
            return false;
        }
        this.fProvider.conditionallyCancelRequests();
        this.fCurrentRequest = new LttngSyntEventRequest(requestTrange, offset, nbRequested, 50000, this, experimentTRange, this.getEventProcessor(), TmfExperiment.getCurrentExperiment().getName(), execType){
            Long fCount;
            ITransEventProcessor processor;
            ITmfTimestamp frunningTimeStamp;
            {
                this.fCount = this.getSynEventCount();
                this.processor = this.getProcessor();
            }

            public void handleData(LttngSyntheticEvent event) {
                super.handleData(event);
                if (event != null) {
                    LttngSyntheticEvent synEvent = event;
                    switch (synEvent.getSynType()) {
                        case STARTREQ: {
                            this.handleRequestStarted();
                            break;
                        }
                        case BEFORE: {
                            this.processor.process((LttngEvent)event, synEvent.getTraceModel());
                            this.fCount = this.fCount + 1L;
                            if (this.fCount == 0L || this.fCount % AbsTimeUpdateView.this.getInputChangedRefresh() != 0L) break;
                            AbsTimeUpdateView.this.modelInputChanged((ILttngSyntEventRequest)this, false);
                            if (!TraceDebug.isDEBUG()) break;
                            this.frunningTimeStamp = event.getTimestamp();
                            TraceDebug.debug("handled: " + this.fCount + " sequence: " + synEvent.getSynType());
                            break;
                        }
                        case AFTER: 
                        case ENDREQ: {
                            this.processor.process((LttngEvent)event, synEvent.getTraceModel());
                            break;
                        }
                    }
                }
            }

            public void handleRequestStarted() {
                this.notifyStarting();
            }

            public void done() {
                super.done();
            }

            public void handleCompleted() {
                super.handleCompleted();
                if (this.isFailed() || this.isCancelled()) {
                    AbsTimeUpdateView.this.modelIncomplete((ILttngSyntEventRequest)this);
                }
                if (TraceDebug.isDEBUG() && this.frunningTimeStamp != null) {
                    TraceDebug.debug("Last event time stamp: " + this.frunningTimeStamp.getValue());
                }
            }
        };
        this.fCurrentRequest.startRequestInd((TmfEventProvider)this.fProvider);
        this.fCurrentRequest.setclearDataInd(clearingData);
        return true;
    }

    protected TmfTimeRange getInitTRange(TmfTimeRange experimentTRange) {
        ITmfTimestamp expStartTime = experimentTRange.getStartTime();
        ITmfTimestamp expEndTime = experimentTRange.getEndTime();
        LttngTimestamp initialEndOfWindow = new LttngTimestamp(expStartTime.getValue() + 100000000L);
        if (initialEndOfWindow.compareTo(expEndTime, false) < 0) {
            return new TmfTimeRange(expStartTime, (ITmfTimestamp)initialEndOfWindow);
        }
        return experimentTRange;
    }

    protected void waitCursor(final boolean waitInd) {
        if (this.tsfviewer != null && !this.tsfviewer.getControl().isDisposed()) {
            Display display = this.tsfviewer.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbsTimeUpdateView.this.tsfviewer != null && !AbsTimeUpdateView.this.tsfviewer.getControl().isDisposed()) {
                        AbsTimeUpdateView.this.tsfviewer.waitCursor(waitInd);
                    }
                }
            });
        }
    }

    protected void modelUpdatePrep(TmfTimeRange timeRange, boolean clearAllData) {
        ItemContainer<?> itemContainer = this.getItemContainer();
        if (clearAllData) {
            itemContainer.clearItems();
        } else {
            itemContainer.clearChildren();
        }
        Object[] itemArr = itemContainer.readItems();
        Arrays.sort(itemArr);
        this.displayModel((ITmfTimeAnalysisEntry[])itemArr, -1L, -1L, false, -1L, -1L, null);
        ParamsUpdater updater = this.getParamsUpdater();
        if (updater != null) {
            updater.setEventsDiscarded(0);
            if (timeRange != null) {
                updater.update(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue());
            }
        }
    }

    protected void modelUpdateInit(TmfTimeRange boundaryRange, TmfTimeRange visibleRange, Object source) {
        ParamsUpdater updater;
        ItemContainer<?> itemContainer;
        if (boundaryRange != null && (itemContainer = this.getItemContainer()) != null) {
            itemContainer.clearItems();
            Object[] itemArr = itemContainer.readItems();
            Arrays.sort(itemArr);
            long startTime = boundaryRange.getStartTime().getValue();
            long endTime = boundaryRange.getEndTime().getValue();
            this.displayModel((ITmfTimeAnalysisEntry[])itemArr, startTime, endTime, true, visibleRange.getStartTime().getValue(), visibleRange.getEndTime().getValue(), source);
        }
        if (visibleRange != null && (updater = this.getParamsUpdater()) != null) {
            updater.setEventsDiscarded(0);
            updater.update(visibleRange.getStartTime().getValue(), visibleRange.getEndTime().getValue());
        }
    }

    protected void modelInputChanged(ILttngSyntEventRequest request, boolean complete) {
        ParamsUpdater paramUpdater;
        Object[] itemArr;
        long experimentStartTime = -1L;
        long experimentEndTime = -1L;
        TmfTimeRange experimentTimeRange = request.getExperimentTimeRange();
        if (experimentTimeRange != null) {
            experimentStartTime = experimentTimeRange.getStartTime().getValue();
            experimentEndTime = experimentTimeRange.getEndTime().getValue();
        }
        if ((itemArr = this.getItemContainer().readItems()) != null) {
            Arrays.sort(itemArr);
            this.displayModel((ITmfTimeAnalysisEntry[])itemArr, experimentStartTime, experimentEndTime, false, request.getRange().getStartTime().getValue(), request.getRange().getEndTime().getValue(), request.getSource());
        }
        if (complete && (paramUpdater = this.getParamsUpdater()) != null && this.tsfviewer != null && !this.tsfviewer.getControl().isDisposed()) {
            final Long selTime = paramUpdater.getSelectedTime();
            if (selTime != null) {
                TraceDebug.debug("View: " + this.getName() + "\n\t\tRestoring the selected time to: " + selTime);
                Display display = this.tsfviewer.getControl().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbsTimeUpdateView.this.tsfviewer != null && !AbsTimeUpdateView.this.tsfviewer.getControl().isDisposed()) {
                            AbsTimeUpdateView.this.tsfviewer.setSelectedTime(selTime.longValue(), false, (Object)this);
                        }
                    }
                });
            }
            if (TraceDebug.isDEBUG()) {
                int eventCount = 0;
                Long count = request.getSynEventCount();
                int pos = 0;
                while (pos < itemArr.length) {
                    eventCount += itemArr[pos].getTraceEvents().size();
                    ++pos;
                }
                int discarded = paramUpdater.getEventsDiscarded();
                int discardedOutofOrder = paramUpdater.getEventsDiscardedWrongOrder();
                int discardedOutofViewRange = paramUpdater.getEventsDiscardedOutOfViewRange();
                int dicardedNotVisible = paramUpdater.getEventsDiscardedNotVisible();
                TmfTimeRange range = request.getRange();
                StringBuilder sb = new StringBuilder("View: " + this.getName() + ", Events handled: " + count + ", Events loaded in view: " + eventCount + ", Number of events discarded: " + discarded + "\n\tNumber of events discarded with start time earlier than next good time: " + discardedOutofOrder + "\n\tDiscarded Not visible: " + dicardedNotVisible + "\n\tDiscarded out of view Range: " + discardedOutofViewRange);
                sb.append("\n\t\tRequested Time Range: " + range.getStartTime() + "-" + range.getEndTime());
                sb.append("\n\t\tExperiment Time Range: " + experimentStartTime + "-" + experimentEndTime);
                TraceDebug.debug(sb.toString());
            }
        }
    }

    protected abstract void modelIncomplete(ILttngSyntEventRequest var1);

    protected abstract ITransEventProcessor getEventProcessor();

    protected abstract void displayModel(ITmfTimeAnalysisEntry[] var1, long var2, long var4, boolean var6, long var7, long var9, Object var11);

    protected abstract ParamsUpdater getParamsUpdater();

    protected abstract ItemContainer<?> getItemContainer();

    protected abstract int getProviderId();
}

