/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.ProviderResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.utility.LiveTraceManager;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions.ImportToProject;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions.PauseTrace;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.connectorservice.TraceConnectorService;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;

public class TraceSubSystem
extends SubSystem
implements ICommunicationsListener {
    private ProviderResource[] fProviders;

    public TraceSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
        this.getConnectorService().addCommunicationsListener((ICommunicationsListener)this);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
    }

    public Object getObjectWithAbsoluteName(String key) {
        return null;
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Object[] allProviders;
        try {
            allProviders = this.getAllProviders();
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"TraceSubSystem", (Throwable)e);
            Object[] children = new SystemMessageObject[]{new SystemMessageObject(e.getSystemMessage(), 0, null)};
            return children;
        }
        NamePatternMatcher subsetter = new NamePatternMatcher(filterString);
        Vector<Object> v = new Vector<Object>();
        int idx = 0;
        while (idx < allProviders.length) {
            if (subsetter.matches(allProviders[idx].getName())) {
                v.addElement(allProviders[idx]);
            }
            ++idx;
        }
        return allProviders;
    }

    protected Object[] internalResolveFilterString(Object parent, String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public void filterEventFilterCreated(Object selectedObject, ISystemFilter newFilter) {
        super.filterEventFilterCreated(selectedObject, newFilter);
        ISystemRegistry registry = SystemStartHere.getSystemRegistry();
        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, null));
    }

    public void filterEventFilterPoolReferenceCreated(ISystemFilterPoolReference newPoolRef) {
        super.filterEventFilterPoolReferenceCreated(newPoolRef);
        if (this.getSystemFilterPoolReferenceManager().getSystemFilterPoolReferenceCount() == 1) {
            ISystemRegistry registry = SystemStartHere.getSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this, 82, null));
        }
    }

    public ProviderResource[] getAllProviders() throws SystemMessageException, InterruptedException {
        ProviderResource[] providers = this.createProviders();
        if (this.fProviders == null) {
            this.fProviders = providers;
        } else {
            int i = 0;
            while (i < this.fProviders.length) {
                int j = 0;
                while (j < providers.length) {
                    if (this.fProviders[i].getName().equals(providers[j].getName())) {
                        this.fProviders[i].refreshTargets(providers[j].getTargets());
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.fProviders != null ? Arrays.copyOf(this.fProviders, this.fProviders.length) : null;
    }

    public TargetResource[] getAllTargets() throws SystemMessageException {
        ArrayList<TargetResource> targets = new ArrayList<TargetResource>();
        if (this.fProviders != null) {
            int i = 0;
            while (i < this.fProviders.length) {
                targets.addAll(Arrays.asList(this.fProviders[i].getTargets()));
                ++i;
            }
        }
        return targets.toArray(new TargetResource[0]);
    }

    public TraceResource[] getAllTraces() throws SystemMessageException {
        ArrayList<TraceResource> traces = new ArrayList<TraceResource>();
        if (this.fProviders != null) {
            int i = 0;
            while (i < this.fProviders.length) {
                ProviderResource provider = this.fProviders[i];
                int numTargets = provider.getTargets().length;
                int j = 0;
                while (j < numTargets) {
                    TargetResource target = provider.getTargets()[j];
                    if (provider.getName().equals("kernel")) {
                        traces.addAll(Arrays.asList(target.getTraces()));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return traces.toArray(new TraceResource[0]);
    }

    public TraceResource[] getAllTraces(String providerName, String targetName) throws SystemMessageException {
        ArrayList<TraceResource> traces = new ArrayList<TraceResource>();
        ProviderResource selectedProvider = null;
        if (this.fProviders != null) {
            int i = 0;
            while (i < this.fProviders.length) {
                ProviderResource provider = this.fProviders[i];
                if (provider.getName().equals(providerName)) {
                    selectedProvider = this.fProviders[i];
                    break;
                }
                ++i;
            }
            if (selectedProvider != null) {
                int numTargets = selectedProvider.getTargets().length;
                int j = 0;
                while (j < numTargets) {
                    TargetResource target = selectedProvider.getTargets()[j];
                    if (target.getName().equals(targetName)) {
                        traces.addAll(Arrays.asList(target.getTraces()));
                        break;
                    }
                    ++j;
                }
            }
        }
        return traces.toArray(new TraceResource[0]);
    }

    public TraceResource findTrace(String providerName, String targetName, String traceName) {
        TraceResource trace = null;
        try {
            TraceResource[] traces = this.getAllTraces(providerName, targetName);
            int i = 0;
            while (i < traces.length) {
                if (traces[i].getName().equals(traceName)) {
                    trace = traces[i];
                    break;
                }
                ++i;
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"TraceSubSystem", (Throwable)e);
        }
        return trace;
    }

    private ProviderResource[] createProviders() throws SystemMessageException {
        ProviderResource[] providers = null;
        try {
            LttControllerServiceProxy service = this.getControllerService();
            providers = (ProviderResource[])new TCFTask<ProviderResource[]>((ILttControllerService)service){
                private final /* synthetic */ ILttControllerService val$service;
                {
                    this.val$service = iLttControllerService;
                }

                public void run() {
                    this.val$service.getProviders(new ILttControllerService.DoneGetProviders(){

                        public void doneGetProviders(IToken token, Exception error, String[] str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            ProviderResource[] providers = new ProviderResource[str.length];
                            int i = 0;
                            while (i < str.length) {
                                ProviderResource tempProvider = new ProviderResource((ISubSystem)TraceSubSystem.this);
                                tempProvider.setName(str[i]);
                                providers[i] = tempProvider;
                                ++i;
                            }
                            this.done(providers);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            if (e instanceof SystemMessageException) {
                throw (SystemMessageException)((Object)e);
            }
            throw new SystemMessageException(Activator.getDefault().getMessage(e));
        }
        int i = 0;
        while (i < providers.length) {
            this.createTargets(providers[i]);
            ++i;
        }
        return providers;
    }

    private TargetResource[] createTargets(ProviderResource provider) throws SystemMessageException {
        TargetResource[] targets;
        try {
            LttControllerServiceProxy service = this.getControllerService();
            targets = (TargetResource[])new TCFTask<TargetResource[]>((ILttControllerService)service, provider){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ ProviderResource val$provider;
                {
                    this.val$service = iLttControllerService;
                    this.val$provider = providerResource;
                }

                public void run() {
                    this.val$service.getTargets(this.val$provider.getName(), new ILttControllerService.DoneGetTargets(){

                        public void doneGetTargets(IToken token, Exception error, String[] str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TargetResource[] targets = new TargetResource[str.length];
                            int i = 0;
                            while (i < str.length) {
                                TargetResource tempTarget = new TargetResource((ISubSystem)TraceSubSystem.this);
                                tempTarget.setName(str[i]);
                                tempTarget.setParent(val$provider);
                                targets[i] = tempTarget;
                                ++i;
                            }
                            this.done(targets);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            provider.setTargets(new TargetResource[0]);
            if (e instanceof SystemMessageException) {
                throw (SystemMessageException)((Object)e);
            }
            throw new SystemMessageException(Activator.getDefault().getMessage(e));
        }
        provider.setTargets(targets);
        int i = 0;
        while (i < targets.length) {
            if (targets[i].getParent().getName().equals("kernel")) {
                this.createTraces(targets[i]);
            }
            ++i;
        }
        return targets;
    }

    private TraceResource[] createTraces(TargetResource target) throws SystemMessageException {
        TraceResource[] traces;
        try {
            LttControllerServiceProxy service = this.getControllerService();
            traces = (TraceResource[])new TCFTask<TraceResource[]>((ILttControllerService)service, target){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ TargetResource val$target;
                {
                    this.val$service = iLttControllerService;
                    this.val$target = targetResource;
                }

                public void run() {
                    this.val$service.getTraces(this.val$target.getParent().getName(), this.val$target.getName(), new ILttControllerService.DoneGetTraces(){

                        public void doneGetTraces(IToken token, Exception error, String[] str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            TraceResource[] traces = new TraceResource[str.length];
                            int i = 0;
                            while (i < str.length) {
                                TraceResource trace = new TraceResource((ISubSystem)TraceSubSystem.this, val$service);
                                trace.setName(str[i]);
                                trace.setParent(val$target);
                                trace.setTraceState(TraceResource.TraceState.CREATED);
                                traces[i] = trace;
                                ++i;
                            }
                            this.done(traces);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            target.setTraces(new TraceResource[0]);
            if (e instanceof SystemMessageException) {
                throw (SystemMessageException)((Object)e);
            }
            throw new SystemMessageException(Activator.getDefault().getMessage(e));
        }
        target.setTraces(traces);
        this.createTraceConfigurations(target, traces);
        return traces;
    }

    private void createTraceConfigurations(TargetResource target, TraceResource[] traces) throws SystemMessageException {
        if (!target.isUst() && traces.length > 0) {
            String[] activeTraceNames;
            try {
                LttControllerServiceProxy service = this.getControllerService();
                activeTraceNames = (String[])new TCFTask<String[]>((ILttControllerService)service, target){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ TargetResource val$target;
                    {
                        this.val$service = iLttControllerService;
                        this.val$target = targetResource;
                    }

                    public void run() {
                        this.val$service.getActiveTraces(this.val$target.getParent().getName(), this.val$target.getName(), new ILttControllerService.DoneGetActiveTraces(){

                            public void doneGetActiveTraces(IToken token, Exception error, String[] str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(str);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (e instanceof SystemMessageException) {
                    throw (SystemMessageException)((Object)e);
                }
                throw new SystemMessageException(Activator.getDefault().getMessage(e));
            }
            int j = 0;
            while (j < activeTraceNames.length) {
                TraceResource trace = target.getTrace(activeTraceNames[j]);
                if (trace != null) {
                    try {
                        LttControllerServiceProxy service = this.getControllerService();
                        TraceConfig traceConfig = (TraceConfig)new TCFTask<TraceConfig>((ILttControllerService)service, target, trace){
                            private final /* synthetic */ ILttControllerService val$service;
                            private final /* synthetic */ TargetResource val$target;
                            private final /* synthetic */ TraceResource val$trace;
                            {
                                this.val$service = iLttControllerService;
                                this.val$target = targetResource;
                                this.val$trace = traceResource;
                            }

                            public void run() {
                                this.val$service.getActiveTraceInfo(this.val$target.getParent().getName(), this.val$target.getName(), this.val$trace.getName(), new ILttControllerService.DoneGetActiveTraceInfo(){

                                    public void doneGetActiveTraceInfo(IToken token, Exception error, String[] strArray) {
                                        if (error != null) {
                                            this.error(error);
                                            return;
                                        }
                                        TraceConfig config = new TraceConfig();
                                        config.setTraceName(val$trace.getName());
                                        config.setTraceTransport("relay");
                                        config.setIsAppend(false);
                                        String[] stringArray = strArray;
                                        int n = strArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String pair = stringArray[n2];
                                            String[] pairArray = pair.split("=");
                                            if (pairArray.length == 2) {
                                                String param = pairArray[0];
                                                String value = pairArray[1];
                                                if (param.equals("destination")) {
                                                    if (value.startsWith("local:")) {
                                                        config.setNetworkTrace(false);
                                                        config.setTracePath(value.substring("local:".length()));
                                                    } else if (value.startsWith("network:")) {
                                                        config.setNetworkTrace(true);
                                                        config.setTracePath(value.substring("network:".length()));
                                                    }
                                                } else if (param.equals("numThread")) {
                                                    config.setNumChannel(Integer.valueOf(value).intValue());
                                                } else if (param.equals("normal_only")) {
                                                    if (value.equals(Boolean.toString(true))) {
                                                        config.setMode(0);
                                                    }
                                                } else if (param.equals("flight_only")) {
                                                    if (value.equals(Boolean.toString(true))) {
                                                        config.setMode(1);
                                                    }
                                                } else if (param.equals("enabled")) {
                                                    if (value.equals(Boolean.toString(true))) {
                                                        val$trace.setTraceState(TraceResource.TraceState.STARTED);
                                                    } else {
                                                        val$trace.setTraceState(TraceResource.TraceState.PAUSED);
                                                    }
                                                }
                                            }
                                            ++n2;
                                        }
                                        this.done(config);
                                    }
                                });
                            }
                        }.get(10L, TimeUnit.SECONDS);
                        trace.setTraceConfig(traceConfig);
                        if (traceConfig != null && traceConfig.isNetworkTrace()) {
                            if (this.fProviders == null) {
                                this.restartTraceNetwork((ILttControllerService)service, trace, traceConfig);
                            }
                            LiveTraceManager.setLiveTrace((String)traceConfig.getTracePath(), (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof SystemMessageException) {
                            throw (SystemMessageException)((Object)e);
                        }
                        throw new SystemMessageException(Activator.getDefault().getMessage(e));
                    }
                }
                ++j;
            }
        }
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                try {
                    final TraceResource[] traces = this.getAllTraces();
                    StringBuffer traceNames = new StringBuffer("");
                    String filler = "";
                    int j = 0;
                    while (j < traces.length) {
                        if (traces[j].isNetworkTraceAndStarted()) {
                            traceNames.append(filler);
                            traceNames.append(traces[j].getName());
                        }
                        filler = ", ";
                        ++j;
                    }
                    if (!"".equals(traceNames.toString())) {
                        final String finalTraceNames = traceNames.toString();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Ltt_ShutdownWarning, (String)(String.valueOf(Messages.Ltt_NetworkTraceRunningWarning) + ":\n" + finalTraceNames));
                                PauseTrace pauseAction = new PauseTrace();
                                pauseAction.setSelectedTraces(new ArrayList<TraceResource>(Arrays.asList(traces)));
                                pauseAction.run(null);
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    if (this.fProviders == null) break;
                    int i = 0;
                    while (i < this.fProviders.length) {
                        this.fProviders[i].removeAllTargets();
                        ++i;
                    }
                    this.fProviders = null;
                }
                catch (SystemMessageException ex) {
                    SystemBasePlugin.logError((String)"TraceSubSystem", (Throwable)ex);
                }
                break;
            }
            case 4: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 5: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                try {
                    this.disconnect();
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public LttControllerServiceProxy getControllerService() throws Exception {
        return ((TraceConnectorService)this.getConnectorService()).getControllerService();
    }

    private void restartTraceNetwork(final ILttControllerService service, final TraceResource trace, final TraceConfig traceConfig) throws Exception {
        boolean ok;
        File newDir = new File(traceConfig.getTracePath());
        if (!newDir.exists()) {
            boolean created = newDir.mkdirs();
            if (!created) {
                throw new Exception(String.valueOf(Messages.Lttng_Control_ErrorCreateTracePath) + ": " + traceConfig.getTracePath());
            }
            if (traceConfig.getProject() != null) {
                ImportToProject.linkTrace(this.getShell(), trace, traceConfig.getProject(), traceConfig.getTraceName());
            }
        }
        if (!(ok = ((Boolean)new TCFTask<Boolean>(){

            public void run() {
                service.stopWriteTraceNetwork(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), new ILttControllerService.DoneStopWriteTraceNetwork(){

                    public void doneStopWriteTraceNetwork(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS)).booleanValue())) {
            return;
        }
        if (trace.getTraceState() == TraceResource.TraceState.PAUSED) {
            ok = (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    service.startTrace(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), new ILttControllerService.DoneStartTrace(){

                        public void doneStartTrace(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
            if (!ok) {
                return;
            }
            trace.setTraceState(TraceResource.TraceState.STARTED);
            Thread.sleep(1000L);
            ok = (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    service.pauseTrace(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), new ILttControllerService.DonePauseTrace(){

                        public void donePauseTrace(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
            if (!ok) {
                return;
            }
            trace.setTraceState(TraceResource.TraceState.PAUSED);
        } else {
            Thread.sleep(1000L);
        }
        new TCFTask<Boolean>(){

            public void run() {
                service.writeTraceNetwork(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), traceConfig.getTracePath(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(false), Boolean.valueOf(true), new ILttControllerService.DoneWriteTraceNetwork(){

                    public void doneWriteTraceNetwork(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }
}

