/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannels;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.ConfigureTraceWizard;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ConfigureTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private TraceResource fSelectedTrace = null;
    private IStructuredSelection fSelection = null;

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void run(IAction arg0) {
        ConfigureTraceWizard wizard = new ConfigureTraceWizard();
        wizard.init(SystemBasePlugin.getActiveWorkbenchWindow().getWorkbench(), this.fSelection);
        WizardDialog wDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        wDialog.open();
        if (wDialog.getReturnCode() != 0) {
            return;
        }
        TraceConfig result = wizard.getTraceConfig();
        if (result != null) {
            TraceChannels channels = result.getTraceChannels();
            for (String chanName : channels.keySet()) {
                TraceChannel chan = channels.get((Object)chanName);
                boolean doIt = false;
                TraceChannel other = new TraceChannel(chan.getName());
                if (this.fSelectedTrace.getTraceConfig() == null || this.fSelectedTrace.getTraceConfig().getTraceChannels() == null) {
                    doIt = true;
                } else if (this.fSelectedTrace.getTraceConfig() != null && this.fSelectedTrace.getTraceConfig().getTraceChannels() != null) {
                    TraceChannel other2 = this.fSelectedTrace.getTraceConfig().getTraceChannels().get((Object)chanName);
                    if (other2 != null) {
                        other = other2;
                    }
                    boolean bl = doIt = !chan.equals((Object)other);
                }
                if (!doIt) continue;
                if (!this.fSelectedTrace.isUst()) {
                    if (chan.isEnabledStatusKnown() && (!other.isEnabledStatusKnown() || chan.isEnabled() != other.isEnabled())) {
                        this.setChannelEnable(chan.getName(), chan.isEnabled());
                    }
                    if (chan.isChannelOverrideStatusKnown() && (!other.isChannelOverrideStatusKnown() || chan.isChannelOverride() != other.isChannelOverride())) {
                        this.setChannelOverwrite(chanName, chan.isChannelOverride());
                    }
                    if (chan.getSubbufNum() != other.getSubbufNum()) {
                        this.setChannelSubbufNum(chanName, chan.getSubbufNum());
                    }
                    if (chan.getSubbufSize() != other.getSubbufSize()) {
                        this.setChannelSubbufSize(chanName, chan.getSubbufSize());
                    }
                }
                if (chan.getTimer() == other.getTimer()) continue;
                this.setChannelTimer(chanName, chan.getTimer());
            }
            if (this.fSelectedTrace.getTraceState() == TraceResource.TraceState.CREATED) {
                this.fSelectedTrace.setTraceState(TraceResource.TraceState.CONFIGURED);
            }
            this.fSelectedTrace.setTraceConfig(result);
            ISystemRegistry registry = SystemStartHere.getSystemRegistry();
            registry.fireRemoteResourceChangeEvent(4, (Object)this.fSelectedTrace, (Object)this.fSelectedTrace.getParent(), this.fSelectedTrace.getSubSystem(), null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator theSet = ((IStructuredSelection)selection).iterator();
            this.fSelection = (IStructuredSelection)selection;
            while (theSet.hasNext()) {
                Object obj = theSet.next();
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTrace = (TraceResource)obj;
                break;
            }
        } else {
            this.fSelection = null;
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    private void setChannelEnable(String channelName, boolean enabled) {
        try {
            LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
            new TCFTask<Boolean>((ILttControllerService)service, channelName, enabled){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ String val$channelName;
                private final /* synthetic */ boolean val$enabled;
                {
                    this.val$service = iLttControllerService;
                    this.val$channelName = string;
                    this.val$enabled = bl;
                }

                public void run() {
                    this.val$service.setChannelEnable(ConfigureTrace.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTrace.this.fSelectedTrace.getParent().getName(), ConfigureTrace.this.fSelectedTrace.getName(), this.val$channelName, Boolean.valueOf(this.val$enabled), new ILttControllerService.DoneSetChannelEnable(){

                        public void doneSetChannelEnable(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorSetChannelEnable) + " (" + Messages.Lttng_Resource_Trace + ": " + this.fSelectedTrace.getName() + ", " + Messages.Lttng_Resource_Channel + ": " + channelName + ")"), (Throwable)sysExp);
        }
    }

    private void setChannelOverwrite(String channelName, boolean override) {
        try {
            LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
            new TCFTask<Boolean>((ILttControllerService)service, channelName, override){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ String val$channelName;
                private final /* synthetic */ boolean val$override;
                {
                    this.val$service = iLttControllerService;
                    this.val$channelName = string;
                    this.val$override = bl;
                }

                public void run() {
                    this.val$service.setChannelOverwrite(ConfigureTrace.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTrace.this.fSelectedTrace.getParent().getName(), ConfigureTrace.this.fSelectedTrace.getName(), this.val$channelName, Boolean.valueOf(this.val$override), new ILttControllerService.DoneSetChannelOverwrite(){

                        public void doneSetChannelOverwrite(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorSetChannelOverwrite) + " (" + Messages.Lttng_Resource_Trace + ": " + this.fSelectedTrace.getName() + ", " + Messages.Lttng_Resource_Channel + ": " + channelName + ")"), (Throwable)sysExp);
        }
    }

    private void setChannelSubbufNum(String channelName, long numSubBuf) {
        try {
            LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
            new TCFTask<Boolean>((ILttControllerService)service, channelName, numSubBuf){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ String val$channelName;
                private final /* synthetic */ long val$numSubBuf;
                {
                    this.val$service = iLttControllerService;
                    this.val$channelName = string;
                    this.val$numSubBuf = l;
                }

                public void run() {
                    this.val$service.setChannelSubbufNum(ConfigureTrace.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTrace.this.fSelectedTrace.getParent().getName(), ConfigureTrace.this.fSelectedTrace.getName(), this.val$channelName, this.val$numSubBuf, new ILttControllerService.DoneSetChannelSubbufNum(){

                        public void doneSetChannelSubbufNum(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorSetSubbufNum) + " (" + Messages.Lttng_Resource_Trace + ": " + this.fSelectedTrace.getName() + ", " + Messages.Lttng_Resource_Channel + ": " + channelName + ")"), (Throwable)sysExp);
        }
    }

    private void setChannelSubbufSize(String channelName, long subBufSize) {
        try {
            LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
            new TCFTask<Boolean>((ILttControllerService)service, channelName, subBufSize){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ String val$channelName;
                private final /* synthetic */ long val$subBufSize;
                {
                    this.val$service = iLttControllerService;
                    this.val$channelName = string;
                    this.val$subBufSize = l;
                }

                public void run() {
                    this.val$service.setChannelSubbufSize(ConfigureTrace.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTrace.this.fSelectedTrace.getParent().getName(), ConfigureTrace.this.fSelectedTrace.getName(), this.val$channelName, this.val$subBufSize, new ILttControllerService.DoneSetChannelSubbufSize(){

                        public void doneSetChannelSubbufSize(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorSetSubbufSize) + " (" + Messages.Lttng_Resource_Trace + ": " + this.fSelectedTrace.getName() + ", " + Messages.Lttng_Resource_Channel + ": " + channelName + ")"), (Throwable)sysExp);
        }
    }

    private void setChannelTimer(String channelName, long timer) {
        try {
            LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
            new TCFTask<Boolean>((ILttControllerService)service, channelName, timer){
                private final /* synthetic */ ILttControllerService val$service;
                private final /* synthetic */ String val$channelName;
                private final /* synthetic */ long val$timer;
                {
                    this.val$service = iLttControllerService;
                    this.val$channelName = string;
                    this.val$timer = l;
                }

                public void run() {
                    this.val$service.setChannelTimer(ConfigureTrace.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTrace.this.fSelectedTrace.getParent().getName(), ConfigureTrace.this.fSelectedTrace.getName(), this.val$channelName, this.val$timer, new ILttControllerService.DoneSetChannelTimer(){

                        public void doneSetChannelTimer(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
            SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorSetChannelTimer) + " (" + Messages.Lttng_Resource_Trace + ": " + this.fSelectedTrace.getName() + ", " + Messages.Lttng_Resource_Channel + ": " + channelName + ")"), (Throwable)sysExp);
        }
    }
}

