/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.trace;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.trace.LTTngTrace;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.utility.LiveTraceManager;
import org.eclipse.linuxtools.lttng.jni.JniTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperimentContext;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperimentLocation;
import org.eclipse.linuxtools.tmf.core.experiment.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class LTTngExperiment<T extends ITmfEvent>
extends TmfExperiment<T> {
    private static final int DEFAULT_INDEX_PAGE_SIZE = 50000;

    public LTTngExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize, false);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize, boolean preIndexExperiment) {
        super(type, id, traces, epoch, indexPageSize, preIndexExperiment);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace<T>[] traces) {
        this(type, id, traces, TmfTimestamp.ZERO, 50000);
    }

    public LTTngExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize);
    }

    public LTTngExperiment(LTTngExperiment<T> other) {
        super(String.valueOf(other.getName()) + "(clone)", other.fType);
        this.fEpoch = other.fEpoch;
        this.fIndexPageSize = other.fIndexPageSize;
        this.fTraces = new ITmfTrace[other.fTraces.length];
        int trace = 0;
        while (trace < other.fTraces.length) {
            this.fTraces[trace] = other.fTraces[trace].copy();
            ++trace;
        }
        this.fNbEvents = other.fNbEvents;
        this.fTimeRange = other.fTimeRange;
    }

    public LTTngExperiment<T> copy() {
        LTTngExperiment<T> experiment = new LTTngExperiment<T>(this);
        TmfSignalManager.deregister(experiment);
        return experiment;
    }

    public synchronized ITmfEvent getNextEvent(ITmfContext context) {
        ITmfEvent[] eventArray;
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.fExperimentContext = this.seekLocation(context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            ITmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
        }
        if ((eventArray = expContext.getEvents()) == null) {
            return null;
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        if (eventArray.length == 1) {
            if (eventArray[0] != null) {
                timestamp = eventArray[0].getTimestamp();
                trace = 0;
            }
        } else {
            int i = 0;
            while (i < eventArray.length) {
                ITmfTimestamp otherTS;
                ITmfEvent event = eventArray[i];
                if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                    trace = i;
                    timestamp = otherTS;
                }
                ++i;
            }
        }
        ITmfEvent event = null;
        if (trace != -1) {
            ITmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation expLocation = (TmfExperimentLocation)expContext.getLocation();
            ((TmfLocationArray)expLocation.getLocation()).locations[trace] = traceContext.getLocation();
            this.updateIndex((ITmfContext)expContext, timestamp);
            expLocation.getRanks()[trace] = traceContext.getRank();
            expContext.setLastTrace(trace);
            expContext.updateRank(1);
            event = expContext.getEvents()[trace];
            this.fExperimentContext = expContext;
        }
        return event;
    }

    protected void indexExperiment(boolean waitForCompletion) {
        if (waitForCompletion) {
            TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal((Object)this, (TmfExperiment)this, TmfTimeRange.ETERNITY);
            this.broadcast((TmfSignal)signal);
            while (this.isIndexingBusy()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            JniTrace jniTrace;
            ITmfTrace trace = iTmfTraceArray[n2];
            if (!(!(trace instanceof LTTngTrace) || (jniTrace = ((LTTngTrace)trace).getCurrentJniTrace()) == null || jniTrace.isLiveTraceSupported() && LiveTraceManager.isLiveTrace(jniTrace.getTracepath()))) {
                this.updateTimeRange();
                TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal((Object)this, (TmfExperiment)this, this.getTimeRange());
                this.broadcast((TmfSignal)signal);
                return;
            }
            ++n2;
        }
        Thread thread = new Thread("Streaming Monitor for " + this.getName()){
            LttngTimestamp safeTimestamp;
            TmfTimeRange timeRange;
            {
                this.safeTimestamp = null;
                this.timeRange = null;
            }

            @Override
            public void run() {
                while (!LTTngExperiment.this.fExecutor.isShutdown()) {
                    TmfEventRequest<LttngEvent> request = new TmfEventRequest<LttngEvent>(LttngEvent.class, TmfTimeRange.ETERNITY, 0, ITmfDataRequest.ExecutionType.FOREGROUND){

                        public void handleCompleted() {
                            super.handleCompleted();
                            if (LTTngExperiment.this.isIndexingBusy()) {
                                timeRange = null;
                                return;
                            }
                            long startTime = Long.MAX_VALUE;
                            long endTime = Long.MIN_VALUE;
                            ITmfTrace[] iTmfTraceArray = LTTngExperiment.this.getTraces();
                            int n = iTmfTraceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITmfTrace trace = iTmfTraceArray[n2];
                                if (trace instanceof LTTngTrace) {
                                    LTTngTrace lttngTrace = (LTTngTrace)trace;
                                    JniTrace jniTrace = lttngTrace.getCurrentJniTrace();
                                    jniTrace.updateTrace();
                                    startTime = Math.min(startTime, lttngTrace.getStartTime().getValue());
                                    endTime = Math.max(endTime, jniTrace.getEndTime().getTime());
                                }
                                ++n2;
                            }
                            LttngTimestamp startTimestamp = new LttngTimestamp(startTime);
                            LttngTimestamp endTimestamp = new LttngTimestamp(endTime);
                            timeRange = safeTimestamp != null && safeTimestamp.compareTo(LTTngExperiment.this.getTimeRange().getEndTime(), false) > 0 ? new TmfTimeRange((ITmfTimestamp)startTimestamp, (ITmfTimestamp)safeTimestamp) : null;
                            safeTimestamp = endTimestamp;
                        }
                    };
                    try {
                        LTTngExperiment.this.sendRequest((ITmfDataRequest)request);
                        request.waitForCompletion();
                        if (this.timeRange != null && !this.timeRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
                            TmfExperimentRangeUpdatedSignal signal = new TmfExperimentRangeUpdatedSignal((Object)LTTngExperiment.this, (TmfExperiment)LTTngExperiment.this, this.timeRange);
                            LTTngExperiment.this.broadcast((TmfSignal)signal);
                        }
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        if (signal.getExperiment() == this) {
            this.indexExperiment(false, (int)this.fNbEvents, signal.getRange());
        }
    }

    public String toString() {
        return "[LTTngExperiment (" + this.getName() + ")]";
    }
}

