/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.Collection;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputPacketIndex {
    private final Vector<StreamInputPacketIndexEntry> entries = new Vector();

    public Collection<StreamInputPacketIndexEntry> getEntries() {
        return this.entries;
    }

    public ListIterator<StreamInputPacketIndexEntry> listIterator() {
        return this.entries.listIterator();
    }

    public ListIterator<StreamInputPacketIndexEntry> listIterator(int n) {
        return this.entries.listIterator(n);
    }

    public void addEntry(StreamInputPacketIndexEntry entry) throws CTFReaderException {
        assert (entry.packetSizeBits != 0);
        assert (entry.contentSizeBits != 0);
        if (entry.timestampBegin > entry.timestampEnd) {
            throw new CTFReaderException("Packet begin timestamp is after end timestamp");
        }
        if (!this.entries.isEmpty() && entry.timestampBegin < this.entries.lastElement().timestampBegin) {
            throw new CTFReaderException("Packets begin timestamp decreasing");
        }
        this.entries.add(entry);
    }

    public ListIterator<StreamInputPacketIndexEntry> search(long timestamp) {
        int guessI;
        int max = this.entries.size() - 1;
        int min = 0;
        StreamInputPacketIndexEntry guessEntry = null;
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp is negative");
        }
        while (true) {
            guessI = (max + min + 1) / 2;
            guessEntry = this.entries.get(guessI);
            if (min == max) break;
            if (timestamp < guessEntry.timestampBegin) {
                max = guessI - 1;
                continue;
            }
            if (timestamp < guessEntry.timestampBegin) continue;
            min = guessI;
        }
        return this.entries.listIterator(guessI);
    }
}

