/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class TmfProjectElement
extends TmfProjectModelElement {
    TmfTraceFolder fTraceFolder = null;
    TmfExperimentFolder fExperimentFolder = null;

    public TmfProjectElement(String name, IProject project, ITmfProjectModelElement parent) {
        super(name, (IResource)project, parent);
    }

    public IProject getResource() {
        return (IProject)this.fResource;
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        super.addChild(child);
        if (child instanceof TmfTraceFolder) {
            this.fTraceFolder = (TmfTraceFolder)child;
            return;
        }
        if (child instanceof TmfExperimentFolder) {
            this.fExperimentFolder = (TmfExperimentFolder)child;
            return;
        }
    }

    public TmfTraceFolder getTracesFolder() {
        return this.fTraceFolder;
    }

    public TmfExperimentFolder getExperimentsFolder() {
        return this.fExperimentFolder;
    }

    @Override
    public void refresh() {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IProject project = TmfProjectElement.this.getResource();
                    project.touch(null);
                }
            }.run(null);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            this.refresh();
        }
    }

    @Override
    public TmfProjectElement getProject() {
        return this;
    }
}

