/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceChannels;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.model.config.TraceChannelCellModifier;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.model.config.TraceChannelTableContentProvider;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.model.config.TraceChannelTableLabelProvider;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards.ITraceChannelConfigurationPage;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards.TraceConfigurationPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class KernelTraceChannelConfigurationPage
extends WizardPage
implements ITraceChannelConfigurationPage {
    private TraceChannels fChannels;
    private TraceResource.TraceState fTraceState;
    private Composite container;
    private TableViewer tableViewer;
    List<String> fColumnNames;
    Action enableAllAction;
    Action disableAllAction;
    Action setOverrideAllAction;
    Action resetOverideAllAction;
    Action setNumSubbufAction;
    Action setSubbufSizeAction;
    Action setChanTimerAction;
    private ColumnData[] columnDataList = new ColumnData[]{new ColumnData(Messages.ChannelConfigPage_ChannelName, 150, 16384, Messages.ChannelConfigPage_ChannelNameTooltip, new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            TraceChannel chan1 = (TraceChannel)e1;
            TraceChannel chan2 = (TraceChannel)e2;
            return chan1.getName().compareTo(chan2.getName());
        }
    }), new ColumnData(Messages.ChannelConfigPage_ChannelEnabled, 150, 16384, Messages.ChannelConfigPage_ChannelEnabledTooltip, null), new ColumnData(Messages.ChannelConfigPage_ChannelOverride, 150, 16384, Messages.ChannelConfigPage_BufferOverrideTooltip, null), new ColumnData(Messages.ChannelConfigPage_NumSubBuf, 175, 16384, Messages.ChannelConfigPage_NumSubBufTooltip, null), new ColumnData(Messages.ChannelConfigPage_SubBufSize, 150, 16384, Messages.ChannelConfigPage_SubBufSizeTooltip, null), new ColumnData(Messages.ChannelConfigPage_ChannelTimer, 150, 16384, Messages.ChannelConfigPage_ChannelTimerTooltip, null)};

    protected KernelTraceChannelConfigurationPage(TraceChannels channels, TraceResource.TraceState state) {
        super("TraceChannelConfigurationPage");
        this.fChannels = channels;
        this.fTraceState = state;
        this.setTitle(Messages.ChannelConfigPage_PageTitle);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.container);
        Composite headerComposite = new Composite(this.container, 4);
        GridLayout headerLayout = new GridLayout(1, true);
        headerLayout.marginHeight = 0;
        headerLayout.marginWidth = 0;
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(headerComposite, 68352);
        this.tableViewer.setUseHashlookup(true);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        this.fColumnNames = new ArrayList<String>();
        int i = 0;
        while (i < this.columnDataList.length) {
            final ColumnData columnData = this.columnDataList[i];
            this.fColumnNames.add(columnData.header);
            final TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnData.header);
            tableColumn.setWidth(columnData.width);
            tableColumn.setAlignment(columnData.alignment);
            tableColumn.setToolTipText(columnData.tooltip);
            tableColumn.setMoveable(false);
            if (columnData.comparator != null) {
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getSortDirection() == 128 || KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getSortColumn() != tableColumn) {
                            KernelTraceChannelConfigurationPage.this.tableViewer.setComparator(columnData.comparator);
                            KernelTraceChannelConfigurationPage.this.tableViewer.getTable().setSortDirection(1024);
                        } else {
                            KernelTraceChannelConfigurationPage.this.tableViewer.setComparator(new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.comparator.compare(viewer, e1, e2);
                                }
                            });
                            KernelTraceChannelConfigurationPage.this.tableViewer.getTable().setSortDirection(128);
                        }
                        KernelTraceChannelConfigurationPage.this.tableViewer.getTable().setSortColumn(tableColumn);
                    }
                });
            }
            ++i;
        }
        this.tableViewer.setColumnProperties(this.fColumnNames.toArray(new String[0]));
        CellEditor[] editors = new CellEditor[this.columnDataList.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)table);
        editors[0] = textEditor;
        editors[1] = new CheckboxCellEditor((Composite)table);
        editors[2] = new CheckboxCellEditor((Composite)table);
        textEditor = new TextCellEditor((Composite)table);
        ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        editors[3] = textEditor;
        textEditor = new TextCellEditor((Composite)table);
        ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        editors[4] = textEditor;
        textEditor = new TextCellEditor((Composite)table);
        ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[0-9]*");
            }
        });
        editors[5] = textEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new TraceChannelCellModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)new TraceChannelTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TraceChannelTableLabelProvider());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.makeActions();
        this.addContextMenu();
    }

    public void dispose() {
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible && this.fChannels != null) {
            this.tableViewer.setInput((Object)this.fChannels);
            Table table = this.tableViewer.getTable();
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < items.length) {
                if (i % 2 != 0) {
                    items[i].setBackground(Display.getDefault().getSystemColor(34));
                }
                if (this.fTraceState != TraceResource.TraceState.CREATED && this.fTraceState != TraceResource.TraceState.CONFIGURED) {
                    items[i].setForeground(Display.getDefault().getSystemColor(16));
                }
                ++i;
            }
            this.container.layout();
        }
        super.setVisible(visible);
    }

    public List<String> getColumnProperties() {
        return this.fColumnNames;
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public TraceResource.TraceState getTraceState() {
        return this.fTraceState;
    }

    public boolean isLocalTrace() {
        TraceConfigurationPage configPage = (TraceConfigurationPage)this.getPreviousPage();
        return configPage.isLocalTrace();
    }

    @Override
    public TraceChannels getTraceChannels() {
        return this.fChannels;
    }

    private void makeActions() {
        this.enableAllAction = new Action(Messages.ChannelConfigPage_EnableAll, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_CHECKED")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    TraceChannel chan = (TraceChannel)items[i].getData();
                    chan.setIsEnabled(true);
                    ++i;
                }
                KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
            }
        };
        this.disableAllAction = new Action(Messages.ChannelConfigPage_DisableAll, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_UNCHECKED")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    TraceChannel chan = (TraceChannel)items[i].getData();
                    chan.setIsEnabled(false);
                    ++i;
                }
                KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
            }
        };
        this.setOverrideAllAction = new Action(Messages.ChannelConfigPage_EnableAllBufferOverride, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_CHECKED")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    TraceChannel chan = (TraceChannel)items[i].getData();
                    chan.setIsChannelOverride(true);
                    ++i;
                }
                KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
            }
        };
        this.resetOverideAllAction = new Action(Messages.ChannelConfigage_DisableAllBufferOverride, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_UNCHECKED")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    TraceChannel chan = (TraceChannel)items[i].getData();
                    chan.setIsChannelOverride(false);
                    ++i;
                }
                KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
            }
        };
        this.setNumSubbufAction = new Action(Messages.ChannelConfigPage_SetAllNumSubBuf, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_EDIT")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                SetDialog setDialog = new SetDialog(KernelTraceChannelConfigurationPage.this.getShell(), Messages.ChannelConfigPage_NumSubBuf);
                if (setDialog.open() == 0) {
                    int i = 0;
                    while (i < items.length) {
                        TraceChannel chan = (TraceChannel)items[i].getData();
                        chan.setSubbufNum(setDialog.getValue().longValue());
                        ++i;
                    }
                    KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
                }
            }
        };
        this.setSubbufSizeAction = new Action(Messages.channelConfigPage_SetAllSubBufSize, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_EDIT")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                SetDialog setDialog = new SetDialog(KernelTraceChannelConfigurationPage.this.getShell(), Messages.ChannelConfigPage_SubBufSize);
                if (setDialog.open() == 0) {
                    int i = 0;
                    while (i < items.length) {
                        TraceChannel chan = (TraceChannel)items[i].getData();
                        chan.setSubbufSize(setDialog.getValue().longValue());
                        ++i;
                    }
                    KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
                }
            }
        };
        this.setChanTimerAction = new Action(Messages.ChannelConfigPage_SetAllChannelTimer, LTTngUiPlugin.getDefault().getImageDescriptor("ICON_ID_EDIT")){

            public void run() {
                TableItem[] items = KernelTraceChannelConfigurationPage.this.tableViewer.getTable().getItems();
                SetDialog setDialog = new SetDialog(KernelTraceChannelConfigurationPage.this.getShell(), Messages.ChannelConfigPage_ChannelTimer);
                if (setDialog.open() == 0) {
                    int i = 0;
                    while (i < items.length) {
                        TraceChannel chan = (TraceChannel)items[i].getData();
                        chan.setTimer(setDialog.getValue().longValue());
                        ++i;
                    }
                    KernelTraceChannelConfigurationPage.this.tableViewer.refresh();
                }
            }
        };
    }

    private void addContextMenu() {
        MenuManager manager = new MenuManager("configChanPopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (KernelTraceChannelConfigurationPage.this.fTraceState != TraceResource.TraceState.CREATED && KernelTraceChannelConfigurationPage.this.fTraceState != TraceResource.TraceState.CONFIGURED) {
                    return;
                }
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.enableAllAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.disableAllAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.setOverrideAllAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.resetOverideAllAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.setNumSubbufAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.setSubbufSizeAction);
                manager.add((IAction)KernelTraceChannelConfigurationPage.this.setChanTimerAction);
            }
        });
        Menu menu = manager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    public final class ColumnData {
        public final String header;
        public final int width;
        public final int alignment;
        public final String tooltip;
        public final ViewerComparator comparator;

        public ColumnData(String h, int w, int a, String t, ViewerComparator c) {
            this.header = h;
            this.width = w;
            this.alignment = a;
            this.tooltip = t;
            this.comparator = c;
        }
    }

    public class SetDialog
    extends Dialog {
        private String fWhat;
        private Text fValueText;
        private Long fValue;

        public SetDialog(Shell parentShell, String what) {
            super(parentShell);
            this.fWhat = null;
            this.fValueText = null;
            this.fValue = null;
            this.fWhat = what;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ChannelConfigPage_SetAll);
            newShell.setImage(LTTngUiPlugin.getDefault().getImage("ICON_ID_EDIT"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 16);
            GridLayout mainLayout = new GridLayout(3, true);
            composite.setLayout((Layout)mainLayout);
            Label what = new Label(composite, 16384);
            what.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
            what.setText(this.fWhat);
            this.fValueText = new Text(composite, 16384);
            this.fValueText.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
            this.fValueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = e.text.matches("[0-9]*");
                }
            });
            this.fValueText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    Button ok = SetDialog.this.getButton(0);
                    ok.setEnabled(SetDialog.this.validateInput(SetDialog.this.fValueText.getText()));
                }
            });
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            ok.setEnabled(false);
        }

        protected void okPressed() {
            this.fValue = Long.valueOf(this.fValueText.getText());
            super.okPressed();
        }

        private boolean validateInput(String path) {
            return path.trim().length() > 0;
        }

        public Long getValue() {
            return this.fValue;
        }
    }
}

