/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.graph;

import java.util.LinkedList;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.BlockAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.ScrollAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IBlockDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IHistoricalDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AreaChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.BarChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.LineChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.MeterChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.PieChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.ScatterChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.graphics.Image;

public final class GraphFactory {
    private static final String[] graphNames = new String[]{Localization.getString("GraphFactory.ScatterGraph"), Localization.getString("GraphFactory.LineGraph"), Localization.getString("GraphFactory.BarGraph"), Localization.getString("GraphFactory.AreaGraph"), Localization.getString("GraphFactory.PieChart")};
    private static final String[] graphDescriptions = new String[]{Localization.getString("GraphFactory.ScatterDescription"), Localization.getString("GraphFactory.LineDescription"), Localization.getString("GraphFactory.BarDescription"), Localization.getString("GraphFactory.AreaDescription"), Localization.getString("GraphFactory.PieDescription")};
    private static final Image[] graphImages = new Image[]{GraphingAPIUIPlugin.getImageDescriptor("icons/graphs/ScatterGraph.gif").createImage(), GraphingAPIUIPlugin.getImageDescriptor("icons/graphs/LineGraph.gif").createImage(), GraphingAPIUIPlugin.getImageDescriptor("icons/graphs/BarGraph.gif").createImage(), GraphingAPIUIPlugin.getImageDescriptor("icons/graphs/AreaChart.gif").createImage(), GraphingAPIUIPlugin.getImageDescriptor("icons/graphs/PieChart.gif").createImage()};
    private static final String[] graphIDs = new String[]{"org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.scatterchartbuilder", "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.linechartbuilder", "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.barchartbuilder", "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.areachartbuilder", "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.piechartbuilder"};

    public static String[] getAvailableGraphs(IDataSet data) {
        LinkedList<String> ids = new LinkedList<String>();
        if (data instanceof IHistoricalDataSet) {
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.scatterchartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.linechartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.areachartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.barchartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.piechartbuilder");
        }
        if (data instanceof IBlockDataSet) {
            if (!ids.contains("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.barchartbuilder")) {
                ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.barchartbuilder");
            }
            ids.add("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.piechartbuilder");
        }
        String[] id = new String[]{};
        return ids.toArray(id);
    }

    public static String getGraphName(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphNames[index];
        }
        return null;
    }

    public static String getGraphDescription(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphDescriptions[index];
        }
        return null;
    }

    public static Image getGraphImage(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphImages[index];
        }
        return null;
    }

    public static boolean isMultiGraph(String id) {
        return !id.equals("org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.piechart");
    }

    public static boolean isKeyRequired(String graphID, IDataSet data) {
        switch (GraphFactory.getIndex(graphID)) {
            case 0: 
            case 1: {
                if (!(data instanceof IBlockDataSet)) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyOptional(String graphID, IDataSet data) {
        switch (GraphFactory.getIndex(graphID)) {
            case 2: {
                if (!(data instanceof IBlockDataSet)) break;
                return true;
            }
        }
        return false;
    }

    public static final AbstractChartBuilder createGraph(GraphComposite comp, int style, GraphData gd, IDataSet data) {
        AbstractChartBuilder builder = null;
        switch (GraphFactory.getIndex(gd.graphID)) {
            case 0: {
                builder = new ScatterChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 1: {
                builder = new LineChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 2: {
                if (!(data instanceof IBlockDataSet) || gd.key != null) {
                    builder = new BarChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                    break;
                }
                builder = new BarChartBuilder(comp, style, gd.title, (IAdapter)new BlockAdapter((IBlockDataSet)data, gd.xSeries, gd.ySeries));
                break;
            }
            case 3: {
                builder = new AreaChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 4: {
                builder = new PieChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 5: {
                builder = new MeterChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
            }
        }
        return builder;
    }

    private static int getIndex(String id) {
        int i = 0;
        while (i < graphIDs.length) {
            if (id.equals(graphIDs[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

