/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvasMouseListener;

class DelayedMouseScroll
extends Thread {
    private HistogramCanvasMouseListener mouseListener = null;
    private long waitTimeBetweenScroll = 0L;
    private long waitTimeBetweenCheck = 0L;
    private long lastScrollTime = 0L;
    private int nbScrollClick = 0;

    public DelayedMouseScroll(HistogramCanvasMouseListener newListener, long newWaitFullTime, long newWaitBeforePoll) {
        this.mouseListener = newListener;
        this.lastScrollTime = System.currentTimeMillis();
        this.waitTimeBetweenScroll = newWaitFullTime;
        this.waitTimeBetweenCheck = newWaitBeforePoll;
    }

    public void incrementMouseScroll() {
        this.lastScrollTime = System.currentTimeMillis();
        ++this.nbScrollClick;
        this.mouseListener.receiveMouseScrollCountWithoutNotification(this.nbScrollClick);
    }

    public void decrementMouseScroll() {
        this.lastScrollTime = System.currentTimeMillis();
        --this.nbScrollClick;
        this.mouseListener.receiveMouseScrollCountWithoutNotification(this.nbScrollClick);
    }

    @Override
    public void run() {
        while (System.currentTimeMillis() - this.lastScrollTime < this.waitTimeBetweenScroll) {
            try {
                Thread.sleep(this.waitTimeBetweenCheck);
            }
            catch (Exception exception) {}
        }
        this.mouseListener.receiveMouseScrollCountWithNotification(this.nbScrollClick);
    }
}

