/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.model.trange;

import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComposite;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;

public class TimeRangeEvent
extends TimeRangeComponent
implements ITimeEvent {
    TimeRangeComposite parent = null;
    protected Type eventType = Type.UNKNOWN;
    protected String stateMode = "";

    public TimeRangeEvent(Long stime, Long etime, TimeRangeComposite eventParent, Type type, String stateMode) {
        super(stime, etime, eventParent);
        this.eventType = type;
        this.stateMode = stateMode;
    }

    @Override
    public long getTime() {
        if (this.startTime == null) {
            return this.eventParent.getStartTime();
        }
        return this.startTime;
    }

    @Override
    public ITmfTimeAnalysisEntry getEntry() {
        return this.parent;
    }

    @Override
    public long getDuration() {
        long startT;
        long duration = -1L;
        long endT = this.stopTime == null ? this.parent.getStopTime() : this.stopTime.longValue();
        long l = startT = this.startTime == null ? this.parent.getStartTime() : this.startTime.longValue();
        if (endT > startT) {
            return this.stopTime - this.startTime;
        }
        return duration;
    }

    public String getStateMode() {
        return this.stateMode;
    }

    public void setStateMode(String stateMode) {
        if (stateMode != null) {
            this.stateMode = stateMode;
        }
    }

    @Override
    public String getName() {
        return this.stateMode;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public void setEventType(Type eventType) {
        this.eventType = eventType;
    }

    public static enum Type {
        UNKNOWN,
        PROPERTY,
        PROCESS_MODE,
        BDEV_MODE,
        TRAP_MODE,
        SOFT_IRQ_MODE,
        IRQ_MODE,
        CPU_MODE;

    }
}

