/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.view.histogram;

import java.util.LinkedList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphNode;
import org.eclipse.linuxtools.gprof.view.histogram.AbstractTreeElement;
import org.eclipse.linuxtools.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.gprof.view.histogram.TreeElement;

public class HistFile
extends AbstractTreeElement {
    public final String sourcePath;
    private final LinkedList<HistFunction> children = new LinkedList();

    public HistFile(HistRoot parent, String path) {
        super(parent);
        this.sourcePath = path;
    }

    private HistFunction getChild(IBinaryParser.ISymbol s) {
        HistFunction f2;
        for (HistFunction f2 : this.children) {
            if (f2.symbol != s) continue;
            return f2;
        }
        f2 = new HistFunction(this, s);
        this.children.add(f2);
        return f2;
    }

    void addBucket(Bucket b, IBinaryParser.ISymbol s, IBinaryParser.IBinaryObject program) {
        HistFunction hf = this.getChild(s);
        hf.addBucket(b, program);
    }

    void addCallGraphNode(CallGraphNode node) {
        IBinaryParser.ISymbol s = node.getSymbol();
        HistFunction hf = this.getChild(s);
        hf.addCallGraphNode(node);
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        Path f = new Path(this.sourcePath);
        return f.lastSegment();
    }

    @Override
    public int getSourceLine() {
        return 0;
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public int getCalls() {
        return -1;
    }
}

