/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.findreplace;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.findreplace.ISTFindReplaceTarget;
import org.eclipse.linuxtools.dataviewers.findreplace.STFindReplaceAction;
import org.eclipse.linuxtools.dataviewers.findreplace.STTreeViewerRow;
import org.eclipse.linuxtools.dataviewers.listeners.ISpecialDrawerListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class STTreeFindReplaceTarget
extends AbstractSTTreeViewer
implements ISTFindReplaceTarget {
    private TreeViewer _viewer = this.getViewer();
    private STFindReplaceAction action;
    private boolean scope;
    private List<TreeItem> fSelections;
    private STTreeViewerRow fRow;

    public STTreeFindReplaceTarget(Composite parent) {
        super(parent, 68354);
        this.addSelectionListener();
    }

    public STTreeFindReplaceTarget(Composite parent, boolean init) {
        super(parent, 68354, init);
        this.addSelectionListener();
    }

    public STTreeFindReplaceTarget(Composite parent, int style) {
        super(parent, style, true);
        this.addSelectionListener();
    }

    public STTreeFindReplaceTarget(Composite parent, int style, boolean init) {
        super(parent, style, init);
        this.addSelectionListener();
    }

    @Override
    public boolean canPerformFind() {
        return this._viewer != null && this._viewer.getInput() != null;
    }

    @Override
    public ViewerCell findAndSelect(ViewerCell widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean wrapSearch, boolean regExSearch) {
        return this.findAndSelect(widgetOffset, findString, searchForward, searchForward, caseSensitive, wholeWord, wrapSearch, regExSearch);
    }

    @Override
    public ViewerCell getSelection(ViewerCell index) {
        if (index == null) {
            if (this.fRow != null) {
                return this.fRow.getCell(0);
            }
            this.fRow = new STTreeViewerRow(this._viewer.getTree().getItem(0));
            return this.fRow.getCell(0);
        }
        return index;
    }

    @Override
    public String getSelectionText(ViewerCell index) {
        if (index == null) {
            if (this.fRow != null) {
                return this.fRow.getCell(0).getText();
            }
            this.fRow = new STTreeViewerRow(this._viewer.getTree().getItem(0));
            return this.fRow.getCell(0).getText();
        }
        return index.getText();
    }

    @Override
    public Boolean isEditable() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private ViewerCell findAndSelect(ViewerCell cell, String findString, boolean searchForward, boolean direction, boolean caseSensitive, boolean wholeWord, boolean wrapSearch, boolean regExSearch) {
        block5: {
            if (cell == null) {
                return null;
            }
            dirCell = ViewerCell.RIGHT;
            if (!searchForward) {
                dirCell = ViewerCell.LEFT;
            }
            if (!(this.scope && this.fSelections.indexOf(cell.getViewerRow().getItem()) == -1 || (cellFound = this.searchInRow(cell.getViewerRow(), cell.getColumnIndex(), findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch)) == null)) {
                return cellFound;
            }
            dirCell = ViewerCell.RIGHT;
            dirRow = 0;
            dirRow = searchForward != false ? 2 : 1;
            row = cell.getViewerRow();
            if (this.fSelections != null) ** GOTO lbl21
            while (row.getNeighbor(dirRow, false) != null) {
                cell = this.searchInRow(row = row.getNeighbor(dirRow, false), 0, findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch);
                if (cell == null) continue;
                return cell;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                row = row.getNeighbor(dirRow, false);
                if (this.scope && this.fSelections.indexOf(cell.getViewerRow().getItem()) == -1 || (cell = this.searchInRow(row, 0, findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch)) == null) continue;
                return cell;
lbl21:
                // 2 sources

                ** while (row.getNeighbor((int)dirRow, (boolean)false) != null)
            }
        }
        return null;
    }

    private ViewerCell searchInRow(ViewerRow row, int index, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, int dirCell, boolean regExSearch) {
        Pattern pattern = null;
        if (regExSearch) {
            pattern = Pattern.compile(findString);
        }
        ISTDataViewersField[] fields = this.getAllFields();
        ViewerCell cell = row.getCell(index);
        do {
            String text = "";
            ISTDataViewersField field = fields[cell.getColumnIndex()];
            if (field.getSpecialDrawer(cell.getElement()) != null) {
                ISpecialDrawerListener hfield = (ISpecialDrawerListener)((Object)field);
                text = hfield.getValue(cell.getElement()).trim();
            } else {
                text = cell.getText().trim();
            }
            boolean ok = false;
            if (regExSearch) {
                Matcher matcher = pattern.matcher(text);
                ok = matcher.find();
            } else if (wholeWord) {
                ok = caseSensitive ? text.equals(findString) : text.equalsIgnoreCase(findString);
            } else {
                ok = text.contains(findString);
                if (ok && caseSensitive) {
                    text.indexOf(findString);
                }
            }
            if (!ok) continue;
            this._viewer.reveal(cell.getElement());
            if (this.fSelections != null && this.fSelections.indexOf(row.getItem()) != -1) {
                this._viewer.getTree().deselectAll();
            }
            return cell;
        } while ((cell = cell.getNeighbor(dirCell, true)) != null);
        return null;
    }

    @Override
    public void setFindAction(STFindReplaceAction action) {
        this.action = action;
    }

    @Override
    protected Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (STTreeFindReplaceTarget.this.action != null) {
                    STTreeFindReplaceTarget.this.action.setEnabled(STTreeFindReplaceTarget.this.canPerformFind());
                }
            }
        });
        return tree;
    }

    @Override
    public ViewerCell getFirstCell(ViewerCell start, int direction) {
        if (direction == 1) {
            STTreeViewerRow row = this.scope && this.fSelections != null ? new STTreeViewerRow(this._viewer.getTree().getSelection()[0]) : new STTreeViewerRow(this._viewer.getTree().getItem(0));
            return row.getCell(0);
        }
        if (this.scope && this.fSelections != null) {
            STTreeViewerRow row = new STTreeViewerRow(this._viewer.getTree().getSelection()[this._viewer.getTree().getSelection().length - 1]);
            return row.getCell(0);
        }
        ViewerRow row = start.getViewerRow();
        while (row.getNeighbor(direction, true) != null) {
            row = row.getNeighbor(direction, true);
        }
        return row.getCell(0);
    }

    @Override
    public void useSelectedLines(boolean use) {
        this.scope = use;
    }

    private void addSelectionListener() {
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TreeItem[] items = STTreeFindReplaceTarget.this._viewer.getTree().getSelection();
                    STTreeFindReplaceTarget.this.fSelections = Arrays.asList(items == null ? new TreeItem[]{} : items);
                    STTreeFindReplaceTarget.this.fRow = new STTreeViewerRow(STTreeFindReplaceTarget.this._viewer.getTree().getSelection()[0]);
                } else {
                    STTreeFindReplaceTarget.this.fRow = null;
                    STTreeFindReplaceTarget.this.fSelections = null;
                }
            }
        });
    }
}

