/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFile;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindLine;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.ICachegrindElement;

public class CachegrindFunction
implements ICachegrindElement {
    protected CachegrindFile parent;
    protected String name;
    protected List<CachegrindLine> lines;
    protected long[] totals;
    protected IAdaptable model;
    private static String SCOPE_RESOLUTION = "::";

    public CachegrindFunction(CachegrindFile parent, String name) {
        this.parent = parent;
        this.name = name;
        this.lines = new ArrayList<CachegrindLine>();
        IAdaptable pModel = parent.getModel();
        if (pModel instanceof ICElement) {
            ICElement element = (ICElement)pModel;
            try {
                if (element instanceof ITranslationUnit) {
                    int paramIndex = name.indexOf("(");
                    if (paramIndex >= 0) {
                        name = name.substring(0, paramIndex);
                    }
                    this.model = this.findElement(name, (IParent)element);
                    if (this.model == null) {
                        while (name.contains(SCOPE_RESOLUTION)) {
                            String[] parts = name.split(SCOPE_RESOLUTION, 2);
                            String structureName = parts[0];
                            name = parts[1];
                            List dom = ((IParent)element).getChildrenOfType(65);
                            dom.addAll(((IParent)element).getChildrenOfType(67));
                            dom.addAll(((IParent)element).getChildrenOfType(69));
                            int i = 0;
                            while (i < dom.size()) {
                                ICElement e = (ICElement)dom.get(i);
                                if (e instanceof IStructure && e.getElementName().equals(structureName)) {
                                    element = (IStructure)e;
                                }
                                ++i;
                            }
                        }
                        this.model = this.findElement(name, (IParent)element);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected ICElement findElement(String name, IParent parent) throws CModelException {
        ICElement element = null;
        List dom = parent.getChildrenOfType(74);
        dom.addAll(parent.getChildrenOfType(70));
        int i = 0;
        while (i < dom.size()) {
            ICElement func = (ICElement)dom.get(i);
            if ((func instanceof IFunction || func instanceof IMethod) && func.getElementName().equals(name)) {
                element = func;
            }
            ++i;
        }
        return element;
    }

    public void addLine(CachegrindLine line) {
        long[] values = line.getValues();
        if (this.totals == null) {
            this.totals = new long[values.length];
        }
        int i = 0;
        while (i < values.length) {
            int n = i;
            this.totals[n] = this.totals[n] + values[i];
            ++i;
        }
        this.lines.add(line);
    }

    public String getName() {
        return this.name;
    }

    public IAdaptable getModel() {
        return this.model;
    }

    public long[] getTotals() {
        return this.totals;
    }

    public CachegrindLine[] getLines() {
        return this.lines.toArray(new CachegrindLine[this.lines.size()]);
    }

    public ICachegrindElement[] getChildren() {
        CachegrindLine[] children = null;
        if (this.lines.get(0).getLine() > 0) {
            children = this.getLines();
        }
        return children;
    }

    public ICachegrindElement getParent() {
        return this.parent;
    }

    public int compareTo(ICachegrindElement o) {
        int result = 0;
        if (o instanceof CachegrindFunction) {
            result = this.name.compareTo(((CachegrindFunction)o).getName());
        }
        return result;
    }
}

