/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;

public class OpenAction
extends Action {
    private static final String OPEN_TRACE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.trace.open";
    private static final String OPEN_EXPERIMENT_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.experiment.open";
    private IWorkbenchPage page;
    private ISelectionProvider selectionProvider;
    private TmfProjectModelElement element;

    public OpenAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.page = page;
        this.selectionProvider = selectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection sSelection;
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() == 1 && (sSelection.getFirstElement() instanceof TmfTraceElement || sSelection.getFirstElement() instanceof TmfExperimentElement)) {
            this.element = (TmfProjectModelElement)sSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        try {
            IHandlerService handlerService = (IHandlerService)this.page.getActivePart().getSite().getService(IHandlerService.class);
            if (this.element instanceof TmfTraceElement) {
                handlerService.executeCommand(OPEN_TRACE_COMMAND_ID, null);
            } else if (this.element instanceof TmfExperimentElement) {
                handlerService.executeCommand(OPEN_EXPERIMENT_COMMAND_ID, null);
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
    }
}

