/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;

public class RPMProjectCreator {
    private RPMProjectLayout layout;
    private IProject latest;

    public RPMProjectCreator(RPMProjectLayout layout) {
        this.layout = layout;
    }

    public RPMProjectCreator() {
        this(RPMProjectLayout.RPMBUILD);
    }

    public void create(String projectName, IPath projectPath, IProgressMonitor monitor) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)projectPath)) {
                description.setLocation(projectPath);
            }
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.rpm.core.rpmnature"});
            project.create(description, monitor);
            monitor.worked(10);
            project.open(monitor);
            if (this.layout.equals((Object)RPMProjectLayout.RPMBUILD)) {
                this.createDirs(monitor, project);
            }
            this.latest = project;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IProject getLatestProject() {
        return this.latest;
    }

    private void createDirs(IProgressMonitor monitor, IProject project) throws CoreException {
        project.getFolder("SPECS").create(true, true, monitor);
        project.getFolder("SOURCES").create(true, true, monitor);
        IFolder buildFolder = project.getFolder("BUILD");
        buildFolder.create(true, true, monitor);
        buildFolder.setHidden(true);
        project.getFolder("RPMS").create(true, true, monitor);
        project.getFolder("SRPMS").create(true, true, monitor);
    }
}

