/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.lttng.core.LTTngCorePlugin;

public class TraceDebug {
    static boolean DEBUG = false;
    static boolean INFO = false;
    static boolean WARN = false;
    private static Plugin plugin = LTTngCorePlugin.getDefault();
    private static String pluginID = "org.eclipse.linuxtools.lttng.core";
    private static SimpleDateFormat stimeformat = new SimpleDateFormat("HH:mm:ss:SSS");

    public static void init() {
        String debugTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/debug"));
        String infoTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/info"));
        String warnTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/warn"));
        if (debugTrace != null) {
            DEBUG = Boolean.valueOf(debugTrace);
        }
        if (infoTrace != null) {
            INFO = Boolean.valueOf(infoTrace);
        }
        if (warnTrace != null) {
            WARN = Boolean.valueOf(warnTrace);
        }
    }

    public static void info(String message) {
        if (INFO) {
            ILog logger = plugin.getLog();
            logger.log((IStatus)new Status(1, "org.eclipse.linuxtools.lttng.core", 0, message, null));
        }
    }

    public static void warn(String message) {
        if (WARN) {
            ILog logger = plugin.getLog();
            logger.log((IStatus)new Status(2, "org.eclipse.linuxtools.lttng.core", 2, message, null));
        }
    }

    public static void debug(String message) {
        if (DEBUG) {
            String location = TraceDebug.getCallingLocation();
            System.out.println(String.valueOf(location) + "\n\t-> " + message);
        }
    }

    public static void debug(String message, int additionalStackLines) {
        if (DEBUG) {
            String location = TraceDebug.getCallingLocation(additionalStackLines);
            System.out.println(String.valueOf(location) + "\n\t-> " + message);
        }
    }

    public static void throwException(String message) {
        if (DEBUG) {
            try {
                TraceDebug.triggerException(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void triggerException(String message) throws Exception {
        throw new Exception(message);
    }

    private static String getCallingLocation() {
        StringBuilder sb = new StringBuilder();
        sb.append(TraceDebug.trace(Thread.currentThread().getStackTrace(), 4));
        sb.append("\n" + TraceDebug.trace(Thread.currentThread().getStackTrace(), 3));
        return sb.toString();
    }

    private static String getCallingLocation(int numOfStackLines) {
        int stackCalledFromIdx = 3;
        int earliestRequested = numOfStackLines > 0 ? stackCalledFromIdx + numOfStackLines : stackCalledFromIdx;
        StringBuilder sb = new StringBuilder();
        int max = Thread.currentThread().getStackTrace().length - 1;
        int i = earliestRequested = earliestRequested > max ? max : earliestRequested;
        while (i >= stackCalledFromIdx) {
            sb.append(String.valueOf(TraceDebug.trace(Thread.currentThread().getStackTrace(), i)) + "\n");
            --i;
        }
        return sb.toString();
    }

    private static String trace(StackTraceElement[] e, int level) {
        StackTraceElement s;
        if (e != null && (s = e[level = level >= e.length ? e.length - 1 : level]) != null) {
            String simpleClassName = s.getClassName();
            String[] clsNameSegs = simpleClassName.split("\\.");
            if (clsNameSegs.length > 0) {
                simpleClassName = clsNameSegs[clsNameSegs.length - 1];
            }
            return String.valueOf(stimeformat.format(new Date())) + " " + simpleClassName + "." + s.getLineNumber() + "." + s.getMethodName();
        }
        return null;
    }

    public static boolean setDEBUG(boolean newValue) {
        boolean oldValue = DEBUG;
        DEBUG = newValue;
        return oldValue;
    }

    public static boolean setINFO(boolean newValue) {
        boolean oldValue = INFO;
        INFO = newValue;
        return oldValue;
    }

    public static boolean setWARN(boolean newValue) {
        boolean oldValue = WARN;
        WARN = newValue;
        return oldValue;
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static boolean isINFO() {
        return INFO;
    }

    public static boolean isWARN() {
        return WARN;
    }
}

