/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.protocol.bundleresource.Handler;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.util.ManifestElement;

public abstract class BundleFile {
    protected static final String PROP_SETPERMS_CMD = "osgi.filepermissions.command";
    static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    protected File basefile;
    private int mruIndex = -1;

    public BundleFile() {
    }

    public BundleFile(File basefile) {
        this.basefile = basefile;
    }

    public abstract File getFile(String var1, boolean var2);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String path, long hostBundleID) {
        return this.getResourceURL(path, hostBundleID, 0);
    }

    public URL getResourceURL(String path, long hostBundleID, int index) {
        BundleEntry bundleEntry = this.getEntry(path);
        if (bundleEntry == null) {
            return null;
        }
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        try {
            return secureAction.getURL("bundleresource", Long.toString(hostBundleID), index, path, new Handler(bundleEntry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getBaseFile() {
        return this.basefile;
    }

    void setMruIndex(int index) {
        this.mruIndex = index;
    }

    int getMruIndex() {
        return this.mruIndex;
    }

    public static void setPermissions(File file) {
        String commandProp = FrameworkProperties.getProperty(PROP_SETPERMS_CMD);
        if (commandProp == null) {
            return;
        }
        String[] temp = ManifestElement.getArrayFromList(commandProp, " ");
        ArrayList<String> command = new ArrayList<String>(temp.length + 1);
        boolean foundFullPath = false;
        int i = 0;
        while (i < temp.length) {
            if ("[fullpath]".equals(temp[i])) {
                command.add(file.getAbsolutePath());
                foundFullPath = true;
            } else {
                command.add(temp[i]);
            }
            ++i;
        }
        if (!foundFullPath) {
            command.add(file.getAbsolutePath());
        }
        try {
            Runtime.getRuntime().exec(command.toArray(new String[command.size()])).waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return String.valueOf(this.basefile);
    }
}

