/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;

public class SimpleConfiguratorUtils {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List readConfiguration(URL url) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                URL baseUrl = new URL(url, "./");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    if (line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) {
                        String baseUrlSt = line.substring("org.eclipse.equinox.simpleconfigurator.baseUrl=".length());
                        if (!baseUrlSt.endsWith("/")) {
                            baseUrlSt = String.valueOf(baseUrlSt) + "/";
                        }
                        baseUrl = new URL(url, baseUrlSt);
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(line, ",", true);
                    String symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    String version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    String urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        new URL(urlSt);
                    }
                    catch (MalformedURLException malformedURLException) {
                        urlSt = Utils.getUrlInFull(urlSt, baseUrl).toExternalForm();
                    }
                    int sl = Integer.parseInt(tok.nextToken().trim());
                    tok.nextToken();
                    boolean markedAsStarted = Boolean.valueOf(tok.nextToken());
                    BundleInfo bInfo = new BundleInfo(symbolicName, version, urlSt, sl, markedAsStarted);
                    bundles.add(bInfo);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var12_15 = null;
                try {}
                catch (IOException iOException) {
                    return bundles;
                }
                r.close();
                return bundles;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return bundles;
    }
}

