/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.internal.core.build;
import org.eclipse.core.runtime.*;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.PDECore;
public class BuildObject implements IBuildObject {
	private IBuildModel model;
	private boolean inTheModel;
	
	public BuildObject() {
	}
	
	public boolean isInTheModel() {
		return inTheModel;
	}
	public void setInTheModel(boolean inTheModel) {
		this.inTheModel = inTheModel;
	}
	protected void ensureModelEditable() throws CoreException {
		if (!model.isEditable()) {
			throwCoreException(PDECore.getResourceString("BuildObject.readOnlyException")); //$NON-NLS-1$
		}
	}
	public IBuildModel getModel() {
		return model;
	}
	void setModel(IBuildModel newModel) {
		model = newModel;
	}
	protected void throwCoreException(String message) throws CoreException {
		Status status = new Status(IStatus.ERROR, PDECore.getPluginId(),
				IStatus.OK, message, null);
		throw new CoreException(status);
	}
	public void restoreProperty(String name, Object oldValue, Object newValue)
			throws CoreException {
	}
}
