/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.core.helpers.MultiStatusUtil;
import org.eclipse.equinox.prov.engine.IProvisioningAction;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractProvisioningTransaction {
    private ArrayList actions = new ArrayList();
    private String description;
    private boolean isUndoable;
    private MultiStatus result;
    private IProgressMonitor progressMonitor;

    public AbstractProvisioningTransaction(String description, boolean isUndoable, MultiStatus result, IProgressMonitor monitor) {
        this.description = description;
        this.isUndoable = isUndoable;
        this.result = result != null ? result : new MultiStatus();
        this.progressMonitor = monitor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus performActions(IProvisioningAction[] ops, int[] weights, IProgressMonitor monitor) {
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)weights.length);
        IStatus status = Status.OK_STATUS;
        try {
            int i = 0;
            while (i < ops.length) {
                IProvisioningAction action = ops[i];
                Object sub = i < weights.length ? pm.newChild(weights[i]) : new NullProgressMonitor();
                status = this.performAction(action, (IProgressMonitor)sub);
                if (!MultiStatusUtil.isErrorOrCancel((IStatus)status)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        pm.done();
        return status;
    }

    protected IStatus performAction(IProvisioningAction action, IProgressMonitor monitor) {
        IStatus opStatus;
        this.actions.add(action);
        IStatus status = opStatus = action.perform(this, monitor);
        if (!this.isUndoable) {
            this.result.add(opStatus);
            status = Status.OK_STATUS;
        } else if (MultiStatusUtil.isErrorOrCancel((IStatus)opStatus)) {
            int length = this.actions.size();
            IProvisioningAction lastAction = (IProvisioningAction)this.actions.get(length - 1);
            if (!lastAction.shouldRevertOnError()) {
                this.actions.remove(length - 1);
            }
        } else if (monitor.isCanceled()) {
            opStatus = new Status(8, "org.eclipse.equinox.prov.engine", 0, "", null);
        }
        if (opStatus.matches(4) && this.result.getMessage().length() == 0) {
            this.result.setMessage(NLS.bind((String)"Errors occurred during the transaction {0}", (Object)this.description));
        } else if (opStatus.matches(8) && this.result.getMessage().length() == 0) {
            this.result.setMessage(NLS.bind((String)"The transaction {0} was canceled", (Object)this.description));
        }
        monitor.done();
        return status;
    }

    public void rollback(IProgressMonitor monitor) {
        if (!this.isUndoable) {
            return;
        }
        this.isUndoable = false;
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.actions.size());
        int i = this.actions.size() - 1;
        while (i >= 0) {
            IProvisioningAction action = (IProvisioningAction)this.actions.get(i);
            try {
                action.revert(this, (IProgressMonitor)pm.newChild(10));
            }
            catch (Exception exception) {}
            --i;
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Transaction: ");
        sb.append(this.description);
        sb.append(", ").append(this.actions.size()).append(" actions performed");
        if (!this.isUndoable) {
            sb.append(", isUndoable=").append(this.isUndoable);
        }
        return sb.toString();
    }
}

