/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.Messages;

public class ChangelogPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = ChangelogPlugin.getDefault().getPreferenceStore();
        store.setDefault("IChangeLogConstants.DATE_FORMAT", "true");
        store.setDefault("IChangeLogConstants.APPEND_RESOURCE_PATH", "false");
        store.setDefault("IChangeLogConstants.AUTHOR_NAME", this.getUserRealName());
        store.setDefault("IChangeLogConstants.AUTHOR_EMAIL", this.getUserEmail());
        store.setDefault("IChangeLogConstants.DEFAULT_FORMATTER", Messages.getString("ChangeLogPreferencesPage.gnuFormatter"));
        store.setDefault("IChangeLogConstants.DEFAULT_EDITOR", Messages.getString("ChangeLogPreferencesPage.gnuEditorConfig"));
    }

    private String getUserRealName() {
        String realUserName = System.getenv("ECLIPSE_CHANGELOG_REALNAME");
        if (realUserName != null) {
            return realUserName;
        }
        return System.getProperty("gnu.gcj.user.realname", this.getUserName());
    }

    private String getUserEmail() {
        String emailID = System.getenv("ECLIPSE_CHANGELOG_EMAIL");
        if (emailID != null) {
            return emailID;
        }
        return this.getUserName() + "@" + this.getHostName();
    }

    private String getUserName() {
        return System.getProperty("user.name");
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost.localdomain";
        }
    }
}

