/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceContainerLabelProvider;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class AddSourceContainerDialog
extends TitleAreaDialog {
    private TableViewer fViewer;
    private SourceContainerViewer fSourceContainerViewer;
    private boolean fDoubleClickSelects = true;
    private ISourceLookupDirector fDirector;

    public AddSourceContainerDialog(Shell shell, SourceContainerViewer viewer, ISourceLookupDirector director) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fSourceContainerViewer = viewer;
        this.fDirector = director;
    }

    protected Control createDialogArea(Composite ancestor) {
        this.getShell().setText(SourceLookupUIMessages.AddSourceContainerDialog_0);
        this.setTitle(SourceLookupUIMessages.AddSourceContainerDialog_1);
        Composite parent = new Composite(ancestor, 0);
        GridData gd = new GridData(1808);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)gd);
        ISourceContainerType[] types = this.filterTypes(DebugPlugin.getDefault().getLaunchManager().getSourceContainerTypes());
        this.fViewer = new TableViewer(parent, 2820);
        final Table table = this.fViewer.getTable();
        gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        if (this.fDoubleClickSelects) {
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (table.getSelectionCount() == 1) {
                        AddSourceContainerDialog.this.okPressed();
                    }
                }
            });
        }
        this.fViewer.setLabelProvider((IBaseLabelProvider)new SourceContainerLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fViewer.setComparator(new ViewerComparator());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                String desc = null;
                if (!selection.isEmpty()) {
                    ISourceContainerType type = (ISourceContainerType)((IStructuredSelection)selection).getFirstElement();
                    desc = type.getDescription();
                }
                AddSourceContainerDialog.this.setMessage(desc);
            }
        });
        if (types.length != 0) {
            this.fViewer.setInput((Object)types);
        }
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.ADD_SOURCE_CONTAINER_DIALOG);
        return parent;
    }

    private ISourceContainerType[] filterTypes(ISourceContainerType[] types) {
        ArrayList<ISourceContainerType> validTypes = new ArrayList<ISourceContainerType>();
        int i = 0;
        while (i < types.length) {
            ISourceContainerBrowser sourceContainerBrowser;
            ISourceContainerType type = types[i];
            if (this.fDirector.supportsSourceContainerType(type) && (sourceContainerBrowser = DebugUITools.getSourceContainerBrowser((String)type.getId())) != null && sourceContainerBrowser.canAddSourceContainers(this.fDirector)) {
                validTypes.add(type);
            }
            ++i;
        }
        return validTypes.toArray(new ISourceContainerType[validTypes.size()]);
    }

    protected void okPressed() {
        ISourceContainer[] results;
        ISourceContainerType type = (ISourceContainerType)((StructuredSelection)this.fViewer.getSelection()).getFirstElement();
        ISourceContainerBrowser browser = DebugUITools.getSourceContainerBrowser((String)type.getId());
        if (browser != null && (results = browser.addSourceContainers(this.getShell(), this.fDirector)) != null) {
            this.fSourceContainerViewer.addEntries(results);
        }
        super.okPressed();
    }
}

