/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.OverridePolicy;
import org.eclipse.ui.navigator.Priority;

public final class NavigatorContentDescriptor
implements INavigatorContentDescriptor,
INavigatorContentExtPtConstants {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private String id;
    private String name;
    private final IConfigurationElement configElement;
    private int priority = 3;
    private int sequenceNumber;
    private String appearsBeforeId;
    private Expression enablement;
    private Expression possibleChildren;
    private Expression initialActivation;
    private String icon;
    private boolean activeByDefault;
    private IPluginContribution contribution;
    private boolean sortOnly;
    private Set overridingExtensions;
    private List overridingExtensionsList;
    private OverridePolicy overridePolicy;
    private String suppressedExtensionId;
    private INavigatorContentDescriptor overriddenDescriptor;
    private int hashCode = -1;
    private boolean providesSaveables;

    NavigatorContentDescriptor(IConfigurationElement configElement) throws WorkbenchException {
        this.configElement = configElement;
        this.init();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(int num) {
        this.sequenceNumber = num;
    }

    @Override
    public String getAppearsBeforeId() {
        return this.appearsBeforeId;
    }

    @Override
    public boolean isSortOnly() {
        return this.sortOnly;
    }

    private void init() throws WorkbenchException {
        this.id = this.configElement.getAttribute("id");
        this.name = this.configElement.getAttribute("name");
        String priorityString = this.configElement.getAttribute("priority");
        this.icon = this.configElement.getAttribute("icon");
        String activeByDefaultString = this.configElement.getAttribute("activeByDefault");
        this.activeByDefault = activeByDefaultString != null && activeByDefaultString.length() > 0 ? Boolean.parseBoolean(activeByDefaultString) : true;
        String providesSaveablesString = this.configElement.getAttribute("providesSaveables");
        this.providesSaveables = providesSaveablesString != null && providesSaveablesString.length() > 0 ? Boolean.parseBoolean(providesSaveablesString) : false;
        this.appearsBeforeId = this.configElement.getAttribute("appearsBefore");
        if (priorityString != null) {
            try {
                Priority p = Priority.get(priorityString);
                this.priority = p != null ? p.getValue() : 3;
            }
            catch (NumberFormatException exception) {
                this.priority = 3;
            }
        }
        this.sequenceNumber = this.priority;
        String sortOnlyString = this.configElement.getAttribute("sortOnly");
        boolean bl = this.sortOnly = sortOnlyString != null && sortOnlyString.length() > 0 ? Boolean.parseBoolean(sortOnlyString) : false;
        if (this.id == null) {
            throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new String[]{"id", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
        }
        this.contribution = new IPluginContribution(){

            public String getLocalId() {
                return NavigatorContentDescriptor.this.getId();
            }

            public String getPluginId() {
                return NavigatorContentDescriptor.this.configElement.getDeclaringExtension().getContributor().getName();
            }
        };
        IConfigurationElement[] children = this.configElement.getChildren("initialActivation");
        if (children.length > 0) {
            if (children.length == 1) {
                this.initialActivation = new CustomAndExpression(children[0]);
            } else {
                throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new String[]{"initialActivation", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
            }
        }
        if (this.sortOnly) {
            return;
        }
        children = this.configElement.getChildren("enablement");
        if (children.length == 0) {
            children = this.configElement.getChildren("triggerPoints");
            if (children.length != 1) {
                throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new String[]{"triggerPoints", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
            }
            this.enablement = new CustomAndExpression(children[0]);
            children = this.configElement.getChildren("possibleChildren");
            if (children.length == 1) {
                this.possibleChildren = new CustomAndExpression(children[0]);
            } else if (children.length > 1) {
                throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new String[]{"possibleChildren", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
            }
        } else if (children.length == 1) {
            try {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
            }
        } else if (children.length > 1) {
            throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Attribute_Missing_Warning, (Object[])new String[]{"enablement", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
        }
        children = this.configElement.getChildren("override");
        if (children.length == 0) {
            this.overridePolicy = OverridePolicy.get("InvokeAlwaysRegardlessOfSuppressedExt");
        } else if (children.length == 1) {
            this.suppressedExtensionId = children[0].getAttribute("suppressedExtensionId");
            this.overridePolicy = OverridePolicy.get(children[0].getAttribute("policy"));
        } else if (children.length > 1) {
            throw new WorkbenchException(NLS.bind((String)CommonNavigatorMessages.Too_many_elements_Warning, (Object[])new String[]{"override", this.id, this.configElement.getDeclaringExtension().getContributor().getName()}));
        }
    }

    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getSuppressedExtensionId() {
        return this.suppressedExtensionId;
    }

    @Override
    public OverridePolicy getOverridePolicy() {
        return this.overridePolicy;
    }

    public IPluginContribution getContribution() {
        return this.contribution;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public ITreeContentProvider createContentProvider() throws CoreException {
        if (Policy.DEBUG_EXTENSION_SETUP) {
            System.out.println("createContentProvider: " + String.valueOf(this));
        }
        return (ITreeContentProvider)this.configElement.createExecutableExtension("contentProvider");
    }

    public ILabelProvider createLabelProvider() throws CoreException {
        if (Policy.DEBUG_EXTENSION_SETUP) {
            System.out.println("createLabelProvider: " + String.valueOf(this));
        }
        return (ILabelProvider)this.configElement.createExecutableExtension("labelProvider");
    }

    @Override
    public boolean isActiveByDefault() {
        if (this.activeByDefault) {
            return true;
        }
        if (this.initialActivation == null) {
            return false;
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(new Object());
        return NavigatorPlugin.safeEvaluate(this.initialActivation, context) == EvaluationResult.TRUE;
    }

    @Override
    public boolean isTriggerPoint(Object anElement) {
        if (this.enablement == null || anElement == null) {
            return false;
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(anElement);
        return NavigatorPlugin.safeEvaluate(this.enablement, context) == EvaluationResult.TRUE;
    }

    @Override
    public boolean isPossibleChild(Object anElement) {
        if (this.enablement == null && this.possibleChildren == null || anElement == null) {
            return false;
        }
        if (anElement instanceof IStructuredSelection) {
            return this.arePossibleChildren((IStructuredSelection)anElement);
        }
        IEvaluationContext context = NavigatorPlugin.getEvalContext(anElement);
        if (this.possibleChildren != null) {
            return NavigatorPlugin.safeEvaluate(this.possibleChildren, context) == EvaluationResult.TRUE;
        }
        if (this.enablement != null) {
            return NavigatorPlugin.safeEvaluate(this.enablement, context) == EvaluationResult.TRUE;
        }
        return false;
    }

    @Override
    public boolean arePossibleChildren(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return false;
        }
        for (Object element : aSelection) {
            if (this.isPossibleChild(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasOverridingExtensions() {
        return this.overridingExtensions != null && this.overridingExtensions.size() > 0;
    }

    @Override
    public Set getOverriddingExtensions() {
        if (this.overridingExtensions == null) {
            this.overridingExtensions = new TreeSet(ExtensionSequenceNumberComparator.DESCENDING);
        }
        return this.overridingExtensions;
    }

    public ListIterator getOverridingExtensionsListIterator(boolean fromStart) {
        if (this.overridingExtensions == null) {
            return Collections.EMPTY_LIST.listIterator();
        }
        if (this.overridingExtensionsList == null) {
            this.overridingExtensionsList = new ArrayList(this.overridingExtensions);
        }
        return this.overridingExtensionsList.listIterator(fromStart ? 0 : this.overridingExtensionsList.size());
    }

    public String toString() {
        return "Content[" + this.id + "(" + this.sequenceNumber + ") , \"" + this.name + "\"]";
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            String hashCodeString = this.configElement.getNamespaceIdentifier() + this.getId();
            this.hashCode = hashCodeString.hashCode();
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    @Override
    public INavigatorContentDescriptor getOverriddenDescriptor() {
        return this.overriddenDescriptor;
    }

    void setOverriddenDescriptor(INavigatorContentDescriptor theOverriddenDescriptor) {
        this.overriddenDescriptor = theOverriddenDescriptor;
    }

    @Override
    public boolean hasSaveablesProvider() {
        return this.providesSaveables;
    }
}

