/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.core;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.core.build.CBuildConfigUtils;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.internal.meson.core.MesonBuildConfiguration;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.IMesonToolChainFile;
import org.eclipse.cdt.meson.core.IMesonToolChainManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;

public class MesonBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.meson.core.provider";

    public String getId() {
        return ID;
    }

    public synchronized ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        if (config.getName().equals("")) {
            return null;
        }
        MesonBuildConfiguration mesonConfig = new MesonBuildConfiguration(config, name);
        IMesonToolChainFile tcFile = mesonConfig.getToolChainFile();
        IToolChain toolChain = mesonConfig.getToolChain();
        if (toolChain == null) {
            return null;
        }
        if (tcFile != null && !toolChain.equals(tcFile.getToolChain())) {
            ILaunchTargetManager launchTargetManager = Activator.getService(ILaunchTargetManager.class);
            return new MesonBuildConfiguration(config, name, tcFile.getToolChain(), tcFile, mesonConfig.getLaunchMode(), launchTargetManager.getLocalLaunchTarget());
        }
        return mesonConfig;
    }

    public ICBuildConfiguration createCBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, ILaunchTarget launchTarget, IProgressMonitor monitor) throws CoreException {
        IMesonToolChainManager manager = Activator.getService(IMesonToolChainManager.class);
        IMesonToolChainFile file = manager.getToolChainFileFor(toolChain);
        if (file == null) {
            Collection<IMesonToolChainFile> files;
            String arch;
            HashMap<String, String> properties = new HashMap<String, String>();
            String os = toolChain.getProperty("os");
            if (os != null && !os.isEmpty()) {
                properties.put("os", os);
            }
            if ((arch = toolChain.getProperty("arch")) != null && !arch.isEmpty()) {
                properties.put("arch", arch);
            }
            if (!(files = manager.getToolChainFilesMatching(properties)).isEmpty()) {
                file = files.iterator().next();
                toolChain = file.getToolChain();
            }
        }
        String cBuildConfigName = this.getCBuildConfigName(project, "meson", toolChain, launchMode, launchTarget);
        ICBuildConfigurationManager cBuildConfigManager = Activator.getService(ICBuildConfigurationManager.class);
        IBuildConfiguration buildConfig = CBuildConfigUtils.createBuildConfiguration((ICBuildConfigurationProvider)this, (IProject)project, (String)cBuildConfigName, (ICBuildConfigurationManager)cBuildConfigManager, (IProgressMonitor)monitor);
        MesonBuildConfiguration cBuildConfig = new MesonBuildConfiguration(buildConfig, cBuildConfigName, toolChain, file, launchMode, launchTarget);
        cBuildConfigManager.addBuildConfiguration(buildConfig, (ICBuildConfiguration)cBuildConfig);
        return cBuildConfig;
    }
}

