/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.jlink.core.preferences;

import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.preferences.Discoverer;
import org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.core.Activator;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultPreferences
extends org.eclipse.embedcdt.debug.gdbjtag.core.preferences.DefaultPreferences {
    public static final String INTERFACE_SWD = "swd";
    public static final String INTERFACE_JTAG = "jtag";
    public static final String ENDIANNESS_LITTLE = "little";
    public static final String ENDIANNESS_BIG = "big";
    public static final String GDB_SERVER_CONNECTION_USB = "usb";
    public static final String GDB_SERVER_CONNECTION_IP = "ip";
    public static final String INTERFACE_SPEED_AUTO = "auto";
    public static final String INTERFACE_SPEED_ADAPTIVE = "adaptive";
    public static final String INTERFACE_SPEED_AUTO_COMMAND = "monitor speed auto";
    public static final String INTERFACE_SPEED_ADAPTIVE_COMMAND = "monitor speed adaptive";
    public static final String INTERFACE_SPEED_FIXED_COMMAND = "monitor speed ";
    protected static final boolean TAB_MAIN_CHECK_PROGRAM_DEFAULT = false;
    protected static final String GDB_SERVER_EXECUTABLE_DEFAULT = "${jlink_path}/${jlink_gdbserver}";
    protected static final String GDB_CLIENT_EXECUTABLE_DEFAULT = "${cross_prefix}gdb${cross_suffix}";
    protected static final String SERVER_OTHER_OPTIONS_DEFAULT = "-singlerun -strict -timeout 0 -nogui";
    protected static final String SERVER_INTERFACE_DEFAULT = "swd";
    protected static final boolean ENABLE_SWO_DEFAULT = true;
    protected static final boolean ENABLE_SEMIHOSTING_DEFAULT = true;
    protected static final boolean SERVER_DO_START_DEFAULT = true;
    protected static final String SERVER_ENDIANNESS_DEFAULT = "little";
    protected static final String SERVER_CONNECTION_DEFAULT = "usb";
    protected static final String SERVER_CONNECTION_ADDRESS_DEFAULT = "";
    protected static final String SERVER_INITIAL_SPEED_DEFAULT = "1000";
    protected static final String CLIENT_OTHER_OPTIONS_DEFAULT = "";
    protected static final String CLIENT_COMMANDS_DEFAULT = "set mem inaccessible-by-default off\n";
    protected static final boolean DO_INITIAL_RESET_DEFAULT = true;
    protected static final String INITIAL_RESET_TYPE_DEFAULT = "";
    protected static final int INITIAL_RESET_SPEED_DEFAULT = 1000;
    protected static final String JLINK_SPEED_DEFAULT = "auto";
    protected static final boolean ENABLE_FLASH_BREAKPOINTS_DEFAULT = true;
    protected static final boolean SEMIHOSTING_TELNET_DEFAULT = true;
    protected static final boolean SEMIHOSTING_CLIENT_DEFAULT = false;
    protected static final int SWO_ENABLE_TARGET_CPU_FREQ_DEFAULT = 0;
    protected static final int SWO_ENABLE_TARGET_SWO_FREQ_DEFAULT = 0;
    protected static final String SWO_ENABLE_TARGET_PORT_MASK_DEFAULT = "0x1";
    protected static final String INIT_OTHER_DEFAULT = "";
    protected static final boolean DO_DEBUG_IN_RAM_DEFAULT = false;
    protected static final boolean DO_PRERUN_RESET_DEFAULT = true;
    protected static final String PRERUN_RESET_TYPE_DEFAULT = "";
    protected static final String PRERUN_OTHER_DEFAULT = "";
    public static final boolean DO_CONNECT_TO_RUNNING_DEFAULT = false;
    public static final String FLASH_DEVICE_NAME_DEFAULT = "";
    public static final int GDB_SERVER_GDB_PORT_NUMBER_DEFAULT = 2331;
    public static final int GDB_SERVER_SWO_PORT_NUMBER_DEFAULT = 2332;
    public static final int GDB_SERVER_TELNET_PORT_NUMBER_DEFAULT = 2333;
    public static final boolean DO_GDB_SERVER_VERIFY_DOWNLOAD_DEFAULT = true;
    public static final boolean DO_GDB_SERVER_INIT_REGS_DEFAULT = true;
    public static final boolean DO_GDB_SERVER_LOCAL_ONLY_DEFAULT = true;
    public static final boolean DO_GDB_SERVER_SILENT_DEFAULT = false;
    public static final String GDB_SERVER_LOG_DEFAULT = "";
    public static final boolean DO_GDB_SERVER_ALLOCATE_CONSOLE_DEFAULT = true;
    public static final boolean DO_GDB_SERVER_ALLOCATE_SEMIHOSTING_CONSOLE_DEFAULT = true;
    public static final boolean USE_REMOTE_TARGET_DEFAULT = true;
    public static final String REMOTE_IP_ADDRESS_LOCALHOST = "localhost";
    public static final String REMOTE_IP_ADDRESS_DEFAULT = "localhost";
    public static final int REMOTE_PORT_NUMBER_DEFAULT = 2331;
    public static final boolean UPDATE_THREAD_LIST_DEFAULT = false;
    public static final boolean DO_STOP_AT_DEFAULT = true;
    public static final boolean DO_CONTINUE_DEFAULT = true;
    public static final String ENABLE_SEMIHOSTING_COMMAND = "monitor semihosting enable";
    public static final String DO_SECOND_RESET_COMMAND = "monitor reset ";
    public static final String STOP_AT_NAME_DEFAULT = "main";
    public static final String DO_FIRST_RESET_COMMAND = "monitor reset ";
    public static final String CLRBP_COMMAND = "monitor clrbp";
    public static final String HALT_COMMAND = "monitor halt";
    public static final String REGS_COMMAND = "monitor regs";
    public static final String FLUSH_REGISTERS_COMMAND = "flushreg";
    public static final String ENABLE_FLASH_BREAKPOINTS_COMMAND = "monitor flash breakpoints ";
    public static final int ENABLE_SEMIHOSTING_IOCLIENT_TELNET_MASK = 1;
    public static final int ENABLE_SEMIHOSTING_IOCLIENT_GDBCLIENT_MASK = 2;
    public static final String ENABLE_SEMIHOSTING_IOCLIENT_COMMAND = "monitor semihosting IOClient ";
    public static final String DISABLE_SWO_COMMAND = "monitor SWO DisableTarget 0xFFFFFFFF";
    public static final String ENABLE_SWO_COMMAND = "monitor SWO EnableTarget ";
    public static final String DO_CONTINUE_COMMAND = "continue";
    private static final String REG_SUBKEY = "\\SEGGER\\J-Link";
    private static final String REG_NAME = "InstallPath";

    public DefaultPreferences(String pluginId) {
        super(pluginId);
    }

    public String getGdbServerExecutable() {
        String value = this.getString("gdb.server.executable", GDB_SERVER_EXECUTABLE_DEFAULT);
        return value;
    }

    public String getGdbClientExecutable() {
        String value = this.getString("gdb.client.executable", GDB_CLIENT_EXECUTABLE_DEFAULT);
        return value;
    }

    public String getExecutableName() {
        String key = "executable.name";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.getExecutableName() = \"" + value + "\"");
        }
        return value;
    }

    public String getExecutableNameOs() {
        String key = EclipseUtils.getKeyOs((String)"executable.name.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.getExecutableNameOs() = \"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putExecutableName(String value) {
        String key = "executable.name";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.putExecutableName(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getInstallFolder() {
        String key = "install.folder";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.getInstallFolder()=\"" + value + "\"");
        }
        return value;
    }

    public void putInstallFolder(String value) {
        String key = "install.folder";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.putInstallFolder(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getSearchPath() {
        String key = "search.path";
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.getSearchPath() = \"" + value + "\"");
        }
        return value;
    }

    public String getSearchPathOs() {
        String key = EclipseUtils.getKeyOs((String)"search.path.%s");
        String value = this.getString(key, "");
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.getSearchPathOs() = \"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public void putSearchPath(String value) {
        String key = "search.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.DefaultPreferences.putSearchPath(\"" + value + "\")");
        }
        this.putString(key, value);
    }

    public String getGdbServerInterface() {
        String value = this.getString("gdb.server.interface", "swd");
        return value;
    }

    public boolean getJLinkEnableSemihosting() {
        try {
            if (this.fPreferences.nodeExists("gdb.jlink.enableSemihosting")) {
                return this.getBoolean("gdb.jlink.enableSemihosting", true);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return true;
    }

    public boolean getJLinkEnableSwo() {
        try {
            if (this.fPreferences.nodeExists("gdb.jlink.enableSwo")) {
                return this.getBoolean("gdb.jlink.enableSwo", true);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return true;
    }

    public boolean getTabMainCheckProgram() {
        return this.getBoolean("tab.main.checkProgram", false);
    }

    public boolean getGdbServerDoStart() {
        return this.getBoolean("gdb.server.doStart", true);
    }

    public String getGdbServerEndianness() {
        return this.getString("gdb.server.endianness", "little");
    }

    public String getGdbServerConnection() {
        return this.getString("gdb.server.connection", "usb");
    }

    public String getGdbServerConnectionAddress() {
        return this.getString("gdb.server.connection.address", "");
    }

    public String getGdbServerInitialSpeed() {
        return this.getString("gdb.server.speed", SERVER_INITIAL_SPEED_DEFAULT);
    }

    public String getGdbServerOtherOptions() {
        return this.getString("gdb.server.other", SERVER_OTHER_OPTIONS_DEFAULT);
    }

    public String getGdbClientOtherOptions() {
        return this.getString("gdb.client.other", "");
    }

    public String getGdbClientCommands() {
        return this.getString("gdb.client.commands", CLIENT_COMMANDS_DEFAULT);
    }

    public boolean getJLinkDoInitialReset() {
        return this.getBoolean("gdb.jlink.doInitialReset", true);
    }

    public String getJLinkInitialResetType() {
        return this.getString("gdb.jlink.initialReset.type", "");
    }

    public int getJLinkInitialResetSpeed() {
        return this.getInt("gdb.jlink.initialReset.speed", 1000);
    }

    public String getJLinkSpeed() {
        return this.getString("gdb.jlink.speed", "auto");
    }

    public boolean getJLinkEnableFlashBreakpoints() {
        return this.getBoolean("gdb.jlink.enableFlashBreakpoints", true);
    }

    public boolean getJLinkSemihostingTelnet() {
        return this.getBoolean("gdb.jlink.semihosting.telnet", true);
    }

    public boolean getJLinkSemihostingClient() {
        return this.getBoolean("gdb.jlink.semihosting.client", false);
    }

    public int getJLinkSwoEnableTargetCpuFreq() {
        return this.getInt("gdb.jlink.swoEnableTarget.cpuFreq", 0);
    }

    public int getJLinkSwoEnableTargetSwoFreq() {
        return this.getInt("gdb.jlink.swoEnableTarget.swoFreq", 0);
    }

    public String getJLinkSwoEnableTargetPortMask() {
        return this.getString("gdb.jlink.swoEnableTarget.portMask", SWO_ENABLE_TARGET_PORT_MASK_DEFAULT);
    }

    public String getJLinkInitOther() {
        return this.getString("gdb.jlink.init.other", "");
    }

    public boolean getJLinkDebugInRam() {
        return this.getBoolean("gdb.jlink.doDebugInRam", false);
    }

    public boolean getJLinkDoPreRunReset() {
        return this.getBoolean("gdb.jlink.doPreRunReset", true);
    }

    public String getJLinkPreRunResetType() {
        return this.getString("gdb.jlink.preRunReset.type", "");
    }

    public String getJLinkPreRunOther() {
        return this.getString("gdb.jlink.preRun.other", "");
    }

    protected String getRegistryInstallFolder(String subFolder, String executableName) {
        String path = Discoverer.getRegistryInstallFolder((String)executableName, (String)subFolder, (String)REG_SUBKEY, (String)REG_NAME);
        return path;
    }
}

