/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui;

import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.internal.meson.ui.Messages;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MesonBuildTab
extends CommonBuildTab {
    private static final String NINJA = "Ninja";
    private Button unixGenButton;
    private Button ninjaGenButton;
    private Text mesonArgsText;
    private Text buildCommandText;
    private Text cleanCommandText;

    protected String getBuildConfigProviderId() {
        return "org.eclipse.cdt.meson.core.provider";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Control tcControl = this.createToolchainSelector(comp);
        tcControl.setLayoutData((Object)new GridData(4, 4, true, false));
        Group mesonGroup = new Group(comp, 0);
        mesonGroup.setText(Messages.MesonBuildTab_Settings);
        mesonGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        mesonGroup.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)mesonGroup, 0);
        label.setText(Messages.MesonBuildTab_Generator);
        Composite genComp = new Composite((Composite)mesonGroup, 2048);
        genComp.setLayout((Layout)new GridLayout(2, true));
        this.unixGenButton = new Button(genComp, 16);
        this.unixGenButton.setText(Messages.MesonBuildTab_UnixMakefiles);
        this.unixGenButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.ninjaGenButton = new Button(genComp, 16);
        this.ninjaGenButton.setText(Messages.MesonBuildTab_Ninja);
        this.ninjaGenButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        label = new Label((Composite)mesonGroup, 0);
        label.setText(Messages.MesonBuildTab_MesonArgs);
        this.mesonArgsText = new Text((Composite)mesonGroup, 2048);
        this.mesonArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mesonArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label((Composite)mesonGroup, 0);
        label.setText(Messages.MesonBuildTab_BuildCommand);
        this.buildCommandText = new Text((Composite)mesonGroup, 2048);
        this.buildCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        label = new Label((Composite)mesonGroup, 0);
        label.setText(Messages.MesonBuildTab_CleanCommand);
        this.cleanCommandText = new Text((Composite)mesonGroup, 2048);
        this.cleanCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cleanCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        String generator = buildConfig.getProperty("meson.generator");
        this.updateGeneratorButtons(generator);
        String mesonArgs = buildConfig.getProperty("meson.arguments");
        if (mesonArgs != null) {
            this.mesonArgsText.setText(mesonArgs);
        } else {
            this.mesonArgsText.setText("");
        }
        String buildCommand = buildConfig.getProperty("meson.command.build");
        if (buildCommand != null) {
            this.buildCommandText.setText(buildCommand);
        } else {
            this.buildCommandText.setText("");
        }
        String cleanCommand = buildConfig.getProperty("meson.command.clean");
        if (cleanCommand != null) {
            this.cleanCommandText.setText(buildCommand);
        } else {
            this.cleanCommandText.setText("");
        }
    }

    private void updateGeneratorButtons(String generator) {
        if (generator == null || generator.equals(NINJA)) {
            this.ninjaGenButton.setSelection(true);
        } else {
            this.unixGenButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        buildConfig.setProperty("meson.generator", this.ninjaGenButton.getSelection() ? NINJA : "Unix Makefiles");
        String mesonArgs = this.mesonArgsText.getText().trim();
        if (!mesonArgs.isEmpty()) {
            buildConfig.setProperty("meson.arguments", mesonArgs);
        } else {
            buildConfig.removeProperty("meson.arguments");
        }
        String buildCommand = this.buildCommandText.getText().trim();
        if (!buildCommand.isEmpty()) {
            buildConfig.setProperty("meson.command.build", buildCommand);
        } else {
            buildConfig.removeProperty("meson.command.build");
        }
        String cleanCommand = this.cleanCommandText.getText().trim();
        if (!cleanCommand.isEmpty()) {
            buildConfig.setProperty("meson.command.clean", cleanCommand);
        } else {
            buildConfig.removeProperty("meson.command.clean");
        }
    }

    protected void saveProperties(Map<String, String> properties) {
        super.saveProperties(properties);
        properties.put("meson.generator", this.ninjaGenButton.getSelection() ? NINJA : "Unix Makefiles");
        properties.put("meson.arguments", this.mesonArgsText.getText().trim());
        properties.put("meson.command.build", this.buildCommandText.getText().trim());
        properties.put("meson.command.clean", this.cleanCommandText.getText().trim());
    }

    protected void restoreProperties(Map<String, String> properties) {
        String mesonArgs;
        block16: {
            super.restoreProperties(properties);
            String gen = properties.get("meson.generator");
            if (gen == null) break block16;
            switch (gen) {
                case "Ninja": {
                    this.ninjaGenButton.setSelection(true);
                    this.unixGenButton.setSelection(false);
                    break;
                }
                case "Unix Makefiles": {
                    this.ninjaGenButton.setSelection(false);
                    this.unixGenButton.setSelection(true);
                }
            }
        }
        if ((mesonArgs = properties.get("meson.arguments")) != null) {
            this.mesonArgsText.setText(mesonArgs);
        } else {
            this.mesonArgsText.setText("");
        }
        String buildCmd = properties.get("meson.command.build");
        if (buildCmd != null) {
            this.buildCommandText.setText(buildCmd);
        } else {
            this.buildCommandText.setText("");
        }
        String cleanCmd = properties.get("meson.command.clean");
        if (cleanCmd != null) {
            this.cleanCommandText.setText(cleanCmd);
        } else {
            this.cleanCommandText.setText("");
        }
    }

    public String getName() {
        return Messages.MesonBuildTab_Meson;
    }
}

