/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;

public class DisassemblyDropAdapter
extends DropTargetAdapter {
    private DisassemblyPart fDisassembly;

    public DisassemblyDropAdapter(DisassemblyPart disassembly) {
        this.fDisassembly = disassembly;
    }

    public void drop(DropTargetEvent event) {
        TransferData dataType = event.currentDataType;
        if (DisassemblyDropAdapter.isFileDataType(dataType)) {
            assert (event.data instanceof String[]);
            String[] fileNames = (String[])event.data;
            this.dropFiles(fileNames);
        } else if (DisassemblyDropAdapter.isTextDataType(dataType)) {
            assert (event.data instanceof String);
            String text = (String)event.data;
            if (text.indexOf(47) != -1 || text.indexOf(46) != -1) {
                this.dropFiles(new String[]{text});
            } else {
                this.dropText(text);
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    private static boolean isFileDataType(TransferData dataType) {
        return FileTransfer.getInstance().isSupportedType(dataType);
    }

    private static boolean isTextDataType(TransferData dataType) {
        return TextTransfer.getInstance().isSupportedType(dataType);
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    private void dropFiles(String[] fileNames) {
        int i = 0;
        while (i < fileNames.length) {
            this.fDisassembly.retrieveDisassembly(fileNames[i], 100, true);
            ++i;
        }
    }

    private void dropText(String text) {
        this.fDisassembly.gotoSymbol(text.trim());
    }
}

