/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.model.IMemoryBlockAddressInfoRetrieval;

public abstract class MemoryBlockAddressInfoItem
implements IMemoryBlockAddressInfoRetrieval.IMemoryBlockAddressInfoItem {
    private final String fName;
    private String fLabel;
    private BigInteger fAddress;
    private BigInteger fLength = BigInteger.ONE;
    private int fColor = 0;

    private MemoryBlockAddressInfoItem(String id, BigInteger address) {
        this.fName = id;
        this.fLabel = id;
        this.fAddress = address;
    }

    public MemoryBlockAddressInfoItem(String id, String address) {
        this(id, MemoryBlockAddressInfoItem.convertValue(address));
    }

    public MemoryBlockAddressInfoItem(String id, BigInteger address, BigInteger length, int color) {
        this(id, address);
        this.fLength = length;
        this.fColor = color;
    }

    public String getId() {
        return this.fName;
    }

    public BigInteger getRangeInAddressableUnits() {
        return this.fLength;
    }

    public int getRegionRGBColor() {
        return this.fColor;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public BigInteger getAddress() {
        return this.fAddress;
    }

    private static BigInteger convertValue(String inValue) {
        int radix = 16;
        BigInteger hexValue = null;
        String value = inValue.replaceAll("0x", "");
        try {
            hexValue = new BigInteger(value, radix);
        }
        catch (NumberFormatException e) {
            hexValue = BigInteger.ZERO;
        }
        return hexValue;
    }

    public void setRangeInAddressableUnits(BigInteger length) {
        this.fLength = length;
    }

    public void setRegionRGBColor(int color) {
        this.fColor = color;
    }

    public void setAddress(BigInteger address) {
        this.fAddress = address;
    }
}

