/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.utils.MarkerConfig;
import org.eclipse.tm4e.ui.internal.utils.ResourceUtils;
import org.eclipse.tm4e.ui.model.ITMDocumentModel;

public final class MarkerUtils {
    private static final String TEXTMARKER_TYPE = "org.eclipse.tm4e.ui.textmarker";
    private static final String PROBLEMMARKER_TYPE = "org.eclipse.tm4e.ui.problemmarker";
    private static final String TASKMARKER_TYPE = "org.eclipse.tm4e.ui.taskmarker";
    private static volatile MarkerConfigs MARKER_CONFIGS = new MarkerConfigs();

    public static synchronized void reloadMarkerConfigs() {
        MARKER_CONFIGS = new MarkerConfigs();
    }

    public static void updateTextMarkers(ModelTokensChangedEvent event) {
        ITMModel model = event.model;
        if (model instanceof ITMDocumentModel) {
            ITMDocumentModel docModel = (ITMDocumentModel)model;
            try {
                MarkerUtils.updateTextMarkers(docModel, ((Range)event.ranges.get((int)0)).fromLineNumber);
            }
            catch (Exception ex) {
                TMUIPlugin.logError(ex);
            }
        }
    }

    private static void updateTextMarkers(ITMDocumentModel docModel, int startLineNumber) throws CoreException {
        Integer lineNumberObj;
        IDocument doc = docModel.getDocument();
        IResource res = ResourceUtils.findResource(doc);
        if (res == null) {
            return;
        }
        int numberOfLines = doc.getNumberOfLines();
        HashMap markersByLineNumber = new HashMap();
        IMarker[] iMarkerArray = res.findMarkers(TEXTMARKER_TYPE, true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            lineNumberObj = MarkerUtils.getLineNumber(marker);
            if (lineNumberObj == null) {
                marker.delete();
            } else {
                int lineNumber = lineNumberObj;
                if (lineNumber >= startLineNumber) {
                    if (lineNumber > numberOfLines) {
                        marker.delete();
                    } else {
                        List markersOfLine = markersByLineNumber.computeIfAbsent(lineNumberObj, k -> new ArrayList(1));
                        markersOfLine.add(marker);
                    }
                }
            }
            ++n2;
        }
        MarkerConfigs markerConfigs = MARKER_CONFIGS;
        Map<String, MarkerConfig> markerConfigByTag = markerConfigs.markerConfigByTag;
        Pattern tagSelectorPattern = markerConfigs.tagSelectorPattern;
        int lineNumber = startLineNumber;
        while (lineNumber <= numberOfLines) {
            lineNumberObj = lineNumber;
            int lineIndex = lineNumber - 1;
            List tokens = docModel.getLineTokens(lineIndex);
            if (tokens != null) {
                int tokensCount = tokens.size();
                List<IMarker> outdatedMarkers = markersByLineNumber.getOrDefault(lineNumberObj, Collections.emptyList());
                int tokenIndex = -1;
                for (TMToken token : tokens) {
                    ++tokenIndex;
                    if (!token.type.contains("comment") || token.type.contains("definition")) continue;
                    TMToken nextToken = tokenIndex + 1 < tokensCount ? (TMToken)tokens.get(tokenIndex + 1) : null;
                    try {
                        Matcher matcher;
                        int lineOffset = doc.getLineOffset(lineIndex);
                        String commentText = doc.get(lineOffset + token.startIndex, (nextToken == null ? doc.getLineLength(lineIndex) : nextToken.startIndex) - token.startIndex);
                        if (commentText.length() < 3 || !(matcher = tagSelectorPattern.matcher(commentText)).find()) continue;
                        MarkerConfig markerConfig = (MarkerConfig)NullSafetyHelper.castNonNull((Object)markerConfigByTag.get(matcher.group(1)));
                        String markerText = commentText.substring(matcher.start()).trim();
                        HashMap<String, Object> attrs = new HashMap<String, Object>();
                        attrs.put("lineNumber", lineNumberObj);
                        attrs.put("message", markerText);
                        switch (markerConfig.type) {
                            case PROBLEM: {
                                attrs.put("severity", markerConfig.asProblemMarkerConfig().severity.value);
                                break;
                            }
                            case TASK: {
                                attrs.put("priority", markerConfig.asTaskMarkerConfig().priority.value);
                            }
                        }
                        attrs.put("userEditable", Boolean.FALSE);
                        attrs.put("sourceId", "TM4E");
                        String markerTypeId = switch (markerConfig.type) {
                            case MarkerConfig.Type.PROBLEM -> PROBLEMMARKER_TYPE;
                            case MarkerConfig.Type.TASK -> TASKMARKER_TYPE;
                            default -> throw new MatchException(null, null);
                        };
                        if (MarkerUtils.removeMatchingMarker(outdatedMarkers, markerTypeId, attrs)) continue;
                        int markerTextStartOffset = lineOffset + token.startIndex + matcher.start();
                        attrs.put("charStart", markerTextStartOffset);
                        attrs.put("charEnd", markerTextStartOffset + markerText.length());
                        res.createMarker(markerTypeId, attrs);
                    }
                    catch (BadLocationException ex) {
                        TMUIPlugin.logTrace((Exception)((Object)ex));
                    }
                }
                if (!outdatedMarkers.isEmpty()) {
                    for (IMarker marker : outdatedMarkers) {
                        marker.delete();
                    }
                }
            }
            ++lineNumber;
        }
    }

    private static @Nullable Integer getLineNumber(IMarker marker) {
        block3: {
            try {
                Object lineNumberAttr = marker.getAttribute("lineNumber");
                if (lineNumberAttr instanceof Integer) {
                    Integer lineNumber = (Integer)lineNumberAttr;
                    return lineNumber;
                }
            }
            catch (CoreException ex) {
                if (!marker.exists()) break block3;
                TMUIPlugin.logError((Exception)((Object)ex));
            }
        }
        return null;
    }

    private static boolean removeMatchingMarker(List<IMarker> markers, String type, Map<String, ?> attributes) {
        if (markers.isEmpty()) {
            return false;
        }
        Iterator<IMarker> it = markers.iterator();
        while (it.hasNext()) {
            IMarker marker = it.next();
            try {
                if (!marker.getType().equals(type)) continue;
                boolean hasMatchingAttrs = true;
                for (Map.Entry<String, ?> attr : attributes.entrySet()) {
                    if (Objects.equals(marker.getAttribute(attr.getKey()), attr.getValue())) continue;
                    hasMatchingAttrs = false;
                    break;
                }
                if (!hasMatchingAttrs) continue;
                it.remove();
                return true;
            }
            catch (CoreException ex) {
                if (!marker.exists()) continue;
                TMUIPlugin.logError((Exception)((Object)ex));
            }
        }
        return false;
    }

    private MarkerUtils() {
    }

    private static final class MarkerConfigs {
        final Map<String, MarkerConfig> markerConfigByTag = new HashMap<String, MarkerConfig>();
        final Pattern tagSelectorPattern;

        MarkerConfigs() {
            for (MarkerConfig markerConfig : PreferenceHelper.loadMarkerConfigs()) {
                this.markerConfigByTag.put(markerConfig.tag, markerConfig);
            }
            this.tagSelectorPattern = Pattern.compile("\\b(" + this.markerConfigByTag.keySet().stream().collect(Collectors.joining("|")) + ")\\b");
        }
    }
}

